import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { UsersModule } from './shared/users/users.module';
import { TypeOrmModule } from '@nestjs/typeorm';
import { config } from '../ormconfig';
import { DoorsModule } from './visoflex360/doors/doors.module';
import { EquipamentsModule } from './visoflex360/equipaments/equipaments.module';
import { FilesModule } from './visoflex360/files/files.module';
import { IndustrialFansModule } from './visoflex360/industrial_fans/industrial_fans.module';
import { ModelsModule } from './visoflex360/models/models.module';
import { CategoryModule } from './shared/category/category.module';
import { ContactsModule } from './visoflex360/contacts/contacts.module';
import { AuthModule } from './shared/auth/auth.module';
import { ConfigModule } from '@nestjs/config';
import { EventEmitterModule } from '@nestjs/event-emitter';
import { WatchersModule } from './visoflex360/watchers/watchers.module';
import { ProductsModule } from './ecommerce/products/products.module';
import { AsaasModule } from './ecommerce/asaas/asaas.module';
import { OrdersModule } from './ecommerce/orders/orders.module';
import { ShoppingCartModule } from './ecommerce/shopping_cart/shopping_cart.module';
import { GroupModule } from './visoflex360/group/group.module';
import { MessagingModule } from './shared/messaging/messaging.module';
import { SignaturesModule } from './ecommerce/signatures/signatures.module';
import { ReportsModule } from './ecommerce/reports/reports.module';
import { ClassModule } from './ecommerce/videos/classes.module';
import { CourseModule } from './ecommerce/courses/courses.module';
import { SubscriptionPlanModule } from './visoflex360/subscription_plan/subscription_plan.module';
import { Course_paymentModule } from './ecommerce/course_payment/course_payment.module';
import { MailerModule } from '@nestjs-modules/mailer';
import { HandlebarsAdapter } from '@nestjs-modules/mailer/dist/adapters/handlebars.adapter';
import { join } from 'path';
import { FreteInfoModule } from './ecommerce/frete_info/frete_info.module';
import { CupomModule } from './ecommerce/cupom/cupom.module';
import { DashboardModule } from './ecommerce/dashboard/dashboard.module';
import { CreditcardModule } from './ecommerce/creditcard/creditcard.module';
import { PostModule } from './visoflex360/post/post.module';
import { AgendaModule } from './visoflex360/agenda/agenda.module';

@Module({
  imports: [
    MailerModule.forRoot({
      transport: {
        host: process.env.MAIL_HOST,
        port: Number(process.env.MAIL_PORT),
        secure: false,
        auth: {
          user: process.env.MAIL_USER,
          pass: process.env.MAIL_PASS,
        },
      },
      defaults: {
        from: `"No Reply" <${process.env.MAIL_FROM}>`,
      },
      template: {
        dir: join(process.cwd(), '/templates'),
        adapter: new HandlebarsAdapter(),
        options: {
          strict: true,
        },
      },
    }),
    EventEmitterModule.forRoot(),
    ConfigModule.forRoot({ isGlobal: true }),
    TypeOrmModule.forRootAsync({
      useFactory: async () => ({
        ...config,
        async onDataSourceInit(dataSource) {
          await dataSource.query('PRAGMA foreign_keys = ON');
        },
      }),
    }),
    TypeOrmModule.forRoot(config),
    UsersModule,
    DoorsModule,
    EquipamentsModule,
    FilesModule,
    IndustrialFansModule,
    ClassModule,
    ModelsModule,
    CategoryModule,
    ContactsModule,
    AuthModule,
    WatchersModule,
    OrdersModule,
    ProductsModule,
    AsaasModule,
    ShoppingCartModule,
    GroupModule,
    MessagingModule,
    ReportsModule,
    SignaturesModule,
    CourseModule,
    SubscriptionPlanModule,
    Course_paymentModule,
    FreteInfoModule,
    CupomModule,
    DashboardModule,
    CreditcardModule,

    PostModule,

    AgendaModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
