"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionPlanService = void 0;
const common_2 = require("@nestjs/common");
const subscription_plan_entity_1 = require("./entities/subscription_plan.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const subscription_plan_user_entity_1 = require("./entities/subscription_plan_user.entity");
const enum_1 = require("../../shared/enums/enum");
const user_entity_1 = require("../../shared/users/entities/user.entity");
let SubscriptionPlanService = class SubscriptionPlanService {
    subscriptionPlanRepository;
    subscriptionPlanUserRepository;
    userRepository;
    constructor(subscriptionPlanRepository, subscriptionPlanUserRepository, userRepository) {
        this.subscriptionPlanRepository = subscriptionPlanRepository;
        this.subscriptionPlanUserRepository = subscriptionPlanUserRepository;
        this.userRepository = userRepository;
    }
    async create(createSubscriptionPlanDto) {
        const existTypePlan = await this.subscriptionPlanRepository.findOne({
            where: {
                nome: createSubscriptionPlanDto.name_plan,
            },
        });
        if (existTypePlan) {
            throw new common_2.BadRequestException('Este plano ja existe');
        }
        const newSubscriptionPlan = this.subscriptionPlanRepository.create({
            ...createSubscriptionPlanDto,
            nome: createSubscriptionPlanDto.name_plan
        });
        return this.subscriptionPlanRepository.save(newSubscriptionPlan);
    }
    async addUserToSubscriptionPlan(createSubscriptionPlanDtoUser) {
        const subscriptionPlan = await this.subscriptionPlanRepository.findOne({
            where: { id: createSubscriptionPlanDtoUser.subscriptionPlanId },
        });
        if (!subscriptionPlan) {
            throw new common_2.NotFoundException(`Plano de assinatura com ID ${createSubscriptionPlanDtoUser.subscriptionPlanId} não encontrado.`);
        }
        const { user_name, email, cnpj } = createSubscriptionPlanDtoUser;
        if (!user_name && !email && !cnpj) {
            throw new common_2.BadRequestException('É necessário fornecer nome de usuário, email ou CNPJ para encontrar o usuário.');
        }
        const userToFind = await this.userRepository.findOne({
            where: [
                { user_name: user_name },
                { email: email },
                { document: cnpj }
            ].filter(c => Object.values(c)[0])
        });
        if (!userToFind) {
            throw new common_2.NotFoundException('Usuário não encontrado com os dados fornecidos.');
        }
        const enddate = new Date();
        enddate.setDate(enddate.getDate() + subscriptionPlan.duration);
        const newUserPlan = this.subscriptionPlanUserRepository.create({
            subscriptionPlan,
            user: userToFind,
            start_date: new Date(),
            end_date: enddate,
            status: enum_1.StatusPlan.ACTIVE,
        });
        this.subscriptionPlanUserRepository.save(newUserPlan);
        return 'Plano de assinatura adicionado com sucesso!';
    }
    async findAllUsersWhithPlan() {
        const userswhithplan = await this.subscriptionPlanUserRepository.createQueryBuilder('subscriptionPlanUser')
            .leftJoin('subscriptionPlanUser.subscriptionPlan', 'subscriptionPlan')
            .leftJoin('subscriptionPlanUser.user', 'user')
            .select('subscriptionPlan', 'subscriptionPlan')
            .addSelect('user.user_name', 'name_user')
            .addSelect('user.email', 'email_user')
            .addSelect('user.id', 'id_user')
            .addSelect('subscriptionPlanUser.start_date', 'start_date')
            .addSelect('subscriptionPlanUser.end_date', 'end_date')
            .addSelect('subscriptionPlanUser.status', 'status')
            .addSelect('subscriptionPlanUser.id', 'id_plan_user')
            .addSelect('subscriptionPlan.price', 'price')
            .addSelect('subscriptionPlan.duration', 'duration')
            .addSelect('subscriptionPlan.nome', 'name_plan')
            .getRawMany();
        const totalRevenue = userswhithplan.reduce((sum, item) => {
            return sum + (Number(item.price) || 0);
        }, 0);
        const totalActive = userswhithplan.filter(item => item.status === enum_1.StatusPlan.ACTIVE).length;
        const newUserThisMonth = userswhithplan.filter(item => item.start_date.getMonth() === new Date().getMonth()).length;
        return { userswhithplan, othersInfo: { totalActive, totalRevenue, newUserThisMonth } };
    }
    async findOneUserWhithPlan(id) {
        const existUserWhithPlan = await this.subscriptionPlanUserRepository.createQueryBuilder('subscriptionPlanUser')
            .where('subscriptionPlanUser.id = :id', { id })
            .leftJoin('subscriptionPlanUser.subscriptionPlan', 'subscriptionPlan')
            .leftJoin('subscriptionPlanUser.user', 'user')
            .select('subscriptionPlan', 'subscriptionPlan')
            .addSelect('user.user_name', 'name_user')
            .addSelect('user.email', 'email_user')
            .addSelect('user.id', 'id_user')
            .addSelect('subscriptionPlanUser.start_date', 'start_date')
            .addSelect('subscriptionPlanUser.end_date', 'end_date')
            .addSelect('subscriptionPlanUser.status', 'status')
            .addSelect('subscriptionPlanUser.id', 'id_plan_user')
            .getRawOne();
        if (!existUserWhithPlan) {
            throw new common_2.BadRequestException('Ops, Usuario sem plano');
        }
        return existUserWhithPlan;
    }
    async findAll() {
        return this.subscriptionPlanRepository.find();
    }
    update(id, updateSubscriptionPlanDto) {
        return `This action updates a #${id} subscriptionPlan`;
    }
    remove(id) {
        return `This action removes a #${id} subscriptionPlan`;
    }
};
exports.SubscriptionPlanService = SubscriptionPlanService;
exports.SubscriptionPlanService = SubscriptionPlanService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(subscription_plan_entity_1.SubscriptionPlan)),
    __param(1, (0, typeorm_2.InjectRepository)(subscription_plan_user_entity_1.SubscriptionPlanUser)),
    __param(2, (0, typeorm_2.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository])
], SubscriptionPlanService);
//# sourceMappingURL=subscription_plan.service.js.map