"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionPlanController = void 0;
const common_2 = require("@nestjs/common");
const subscription_plan_service_1 = require("./subscription_plan.service");
const create_subscription_plan_dto_1 = require("./dto/create-subscription_plan.dto");
const update_subscription_plan_dto_1 = require("./dto/update-subscription_plan.dto");
const create_subscription_plan_user_dto_1 = require("./dto/create-subscription_plan_user.dto");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const permissions_guards_1 = require("../../shared/auth/permissions.guards");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const enum_1 = require("../../shared/enums/enum");
let SubscriptionPlanController = class SubscriptionPlanController {
    subscriptionPlanService;
    constructor(subscriptionPlanService) {
        this.subscriptionPlanService = subscriptionPlanService;
    }
    create(createSubscriptionPlanDto) {
        return this.subscriptionPlanService.create(createSubscriptionPlanDto);
    }
    addUserToSubscriptionPlan(createSubscriptionPlanDtoUser) {
        return this.subscriptionPlanService.addUserToSubscriptionPlan(createSubscriptionPlanDtoUser);
    }
    findAllUsersWhithPlan() {
        return this.subscriptionPlanService.findAllUsersWhithPlan();
    }
    findOneUserWhithPlan(id) {
        return this.subscriptionPlanService.findOneUserWhithPlan(+id);
    }
    findAll() {
        return this.subscriptionPlanService.findAll();
    }
    update(id, updateSubscriptionPlanDto) {
        return this.subscriptionPlanService.update(+id, updateSubscriptionPlanDto);
    }
    remove(id) {
        return this.subscriptionPlanService.remove(+id);
    }
};
exports.SubscriptionPlanController = SubscriptionPlanController;
__decorate([
    (0, common_2.Post)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMVISO360),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_subscription_plan_dto_1.CreateSubscriptionPlanDto]),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "create", null);
__decorate([
    (0, common_2.Post)('add-user'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_subscription_plan_user_dto_1.CreateSubscriptionPlanDtoUser]),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "addUserToSubscriptionPlan", null);
__decorate([
    (0, common_2.Get)('users-with-plan'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "findAllUsersWhithPlan", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "findOneUserWhithPlan", null);
__decorate([
    (0, common_2.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "findAll", null);
__decorate([
    (0, common_2.Patch)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_subscription_plan_dto_1.UpdateSubscriptionPlanDto]),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SubscriptionPlanController.prototype, "remove", null);
exports.SubscriptionPlanController = SubscriptionPlanController = __decorate([
    (0, common_2.Controller)('subscription-plan'),
    __metadata("design:paramtypes", [subscription_plan_service_1.SubscriptionPlanService])
], SubscriptionPlanController);
//# sourceMappingURL=subscription_plan.controller.js.map