"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostModule = void 0;
const common_2 = require("@nestjs/common");
const post_service_1 = require("./post.service");
const post_controller_1 = require("./post.controller");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const post_entity_1 = require("./entities/post.entity");
const comentario_entity_1 = require("./entities/comentario.entity");
const postInteration_entity_1 = require("./entities/postInteration.entity");
const courses_module_1 = require("../../ecommerce/courses/courses.module");
const agenda_module_1 = require("../agenda/agenda.module");
let PostModule = class PostModule {
};
exports.PostModule = PostModule;
exports.PostModule = PostModule = __decorate([
    (0, common_2.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forFeature([post_entity_1.Post, comentario_entity_1.Comentario, postInteration_entity_1.PostInteration]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret',
            }),
            courses_module_1.CourseModule,
            agenda_module_1.AgendaModule,
        ],
        controllers: [post_controller_1.PostController],
        providers: [post_service_1.PostService],
    })
], PostModule);
//# sourceMappingURL=post.module.js.map