"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentsService = void 0;
const equipament_entity_1 = require("./entities/equipament.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const door_entity_1 = require("../doors/entities/door.entity");
const doors_service_1 = require("../doors/doors.service");
const industrial_fan_entity_1 = require("../industrial_fans/entities/industrial_fan.entity");
const industrial_fans_service_1 = require("../industrial_fans/industrial_fans.service");
const common_2 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const model_entity_1 = require("../models/entities/model.entity");
const watcher_entity_1 = require("../watchers/entities/watcher.entity");
const schedules_entity_1 = require("./entities/schedules.entity");
const enum_1 = require("../../shared/enums/enum");
const group_entity_1 = require("../group/entities/group.entity");
let EquipamentsService = class EquipamentsService {
    equipamentRepository;
    doorsRepository;
    userRepository;
    modelRepository;
    watcherRepository;
    industrialFanRepository;
    scheduleRepository;
    groupRepository;
    doorsService;
    industrialFanService;
    eventEmitter;
    dataSource;
    constructor(equipamentRepository, doorsRepository, userRepository, modelRepository, watcherRepository, industrialFanRepository, scheduleRepository, groupRepository, doorsService, industrialFanService, eventEmitter, dataSource) {
        this.equipamentRepository = equipamentRepository;
        this.doorsRepository = doorsRepository;
        this.userRepository = userRepository;
        this.modelRepository = modelRepository;
        this.watcherRepository = watcherRepository;
        this.industrialFanRepository = industrialFanRepository;
        this.scheduleRepository = scheduleRepository;
        this.groupRepository = groupRepository;
        this.doorsService = doorsService;
        this.industrialFanService = industrialFanService;
        this.eventEmitter = eventEmitter;
        this.dataSource = dataSource;
    }
    async createFirstConnection(createEquipamentDto) {
        console.log(createEquipamentDto);
        const user = await this.userRepository.findOneBy({ sinc_code: createEquipamentDto.sinc_code });
        if (!user) {
            throw new common_2.NotFoundException("Código de sincronização inválido. \n Motivo: Não há nenhum usuário relacionado com esse código");
        }
        else if (!user.is_aproved) {
            throw new common_2.ForbiddenException("Código de sincronização inválido. \n Motivo: Usuário não aprovado");
        }
        const equipamentExist = await this.equipamentRepository.findOne({
            where: {
                mac_address: createEquipamentDto.mac_address,
            },
            select: ['id'],
            relations: ['user']
        });
        const { category_id } = await this.modelRepository
            .createQueryBuilder('model')
            .innerJoin('model.category', 'category')
            .select([
            'category.id'
        ])
            .where('model.id = :id', { id: createEquipamentDto.model })
            .getRawOne();
        if (!category_id) {
            throw new common_2.NotFoundException("Não foi possível encontrar uma categoria de equipamento pelo campo \"model\" informado");
        }
        let equipamentCreated;
        if (!equipamentExist) {
            try {
                let prefixo = ((createEquipamentDto.model.id == 1) ? "Porta_" : "VentoBrisa_");
                const equipament = this.equipamentRepository.create({
                    mac_address: createEquipamentDto.mac_address,
                    internal_id: createEquipamentDto.internal_id,
                    section: createEquipamentDto.section,
                    equipament_name: prefixo + createEquipamentDto.equipament_name,
                    model: createEquipamentDto.model,
                    user: user ? { id: user?.id } : null
                });
                equipamentCreated = await this.equipamentRepository.save(equipament);
            }
            catch (error) {
                throw new common_2.BadRequestException("Erro ao criar o equipamento: " + error.message);
            }
            switch (category_id) {
                case 1:
                    this.doorsService.create({ id: equipamentCreated.id });
                case 2:
                    this.industrialFanService.create({ id: equipamentCreated.id });
            }
        }
        else {
            if (equipamentExist.user?.id == user.id) {
                throw new common_2.ConflictException("Este equipamento já está vinculado ao usuário do sinc_code informado");
            }
            ;
            try {
                await this.equipamentRepository.update(equipamentExist.id, equipamentExist);
                return "Proprietário do equipamento alterado";
            }
            catch (error) {
                throw new common_2.NotFoundException("Erro ao tentar atualizar o usuário proprietário");
            }
        }
        return equipamentCreated;
    }
    async addEquipamentToGroup(currentUserId, addEquipamentToGroupDto) {
        const { equipId, groupId } = addEquipamentToGroupDto;
        const equipament = await this.equipamentRepository.findOne({ where: { id: equipId, user: { id: currentUserId } } });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado ou não pertence ao usuário.");
        }
        const group = await this.groupRepository.findOne({ where: { id: groupId, user: { id: currentUserId } } });
        if (!group) {
            throw new common_2.NotFoundException("Grupo não encontrado ou não pertence ao usuário.");
        }
        equipament.group = group;
        await this.equipamentRepository.save(equipament);
        return { message: "Equipamento adicionado ao grupo com sucesso." };
    }
    countAll() {
        const getEquipament = this.equipamentRepository.count();
        return getEquipament;
    }
    async findAll() {
        const equipament = await this.equipamentRepository
            .createQueryBuilder('equipament')
            .leftJoinAndSelect('equipament.user', 'user')
            .leftJoinAndSelect('equipament.fan', 'fan')
            .leftJoinAndSelect('equipament.door', 'door')
            .select([
            'equipament.id',
            'equipament.equipament_name',
            'equipament.mac_address',
            'equipament.section',
            'equipament.created_at',
            'user.id',
            'user.sinc_code',
            'user.user_name',
            'user.document',
            'user.company_name',
            'door',
            'fan'
        ])
            .getMany();
        return equipament;
    }
    async ping(mac) {
        const equipament = await this.equipamentRepository.findOne({
            where: {
                mac_address: mac,
            },
            relations: ['door', 'fan'],
        });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado");
        }
        let schedules;
        if (equipament.fan) {
            schedules = await this.scheduleRepository.findOneBy({ id: equipament.id });
        }
        return {
            message: "Conectado a Visoflex360",
            more: schedules ?? "Sem mais dados"
        };
    }
    ;
    async findSchedulesByEquipament(equipId, id) {
        console.log(equipId, id);
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        const equipament = await this.equipamentRepository
            .createQueryBuilder('equipament')
            .innerJoinAndSelect('equipament.fan', 'fan')
            .innerJoinAndSelect('fan.schedules', 'schedules')
            .where('equipament.id = :equipId', { equipId })
            .andWhere('equipament.userId = :userId', { userId: user.id })
            .getOne();
        if (!equipament || !equipament.fan) {
            throw new common_2.NotFoundException("Equipamento não encontrado");
        }
        return equipament.fan.schedules;
    }
    async findMonitoredEquipaments(id) {
        const user = this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não foi encontrado");
        }
        const owners = await this.watcherRepository
            .createQueryBuilder('watcher')
            .select('DISTINCT watcher.owner_id')
            .where('watcher.watcher_id = :id', { id })
            .getRawMany();
        let equipamentList = [];
        for (const item of owners) {
            const equipaments = await this.findAllByUser(item.owner_id);
            const companyName = await this.userRepository.findOne({
                where: {
                    id: item.owner_id
                },
                select: ['company_name']
            });
            equipamentList.push({
                "company_name": companyName?.company_name || "Empresa Não Definida",
                "equipaments": equipaments
            });
        }
        return equipamentList;
    }
    countAllByUser(userId) {
        return this.equipamentRepository.count({ where: { user: { id: userId } } });
    }
    async countForCards() {
        const totalEquipaments = await this.countAll();
        const totalDoors = await this.countByType("porta");
        const totalFans = await this.countByType("ventilador");
        return { totalEquipaments, totalDoors, totalFans };
    }
    async findAllByUser(id) {
        return this.getEquips(id);
    }
    async findOne(id, type) {
        let getEquipament;
        if (type === "porta") {
            getEquipament = await this.equipamentRepository
                .createQueryBuilder("equipament")
                .innerJoinAndMapOne("equipament.door", door_entity_1.Door, "door", "door.id = equipament.id")
                .getOne();
        }
        else if (type === "ventilador") {
            getEquipament = await this.equipamentRepository
                .createQueryBuilder("equipament")
                .innerJoinAndMapMany("equipament.fan", industrial_fan_entity_1.IndustrialFan, "fan", "fan.id = equipament.id")
                .getOne();
        }
        return getEquipament;
    }
    async countByType(type, userId) {
        const query = this.equipamentRepository
            .createQueryBuilder("equipaments")
            .innerJoinAndSelect("equipaments.model", "m")
            .innerJoinAndSelect("m.category", "c")
            .where("c.category_name = :type", { type });
        userId ? query.andWhere("equipaments.user.id = :userId", { userId }) : null;
        const getEquipaments = await query.getRawMany();
        return getEquipaments.length;
    }
    async update(equipId, id, updateEquipamentDto) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        ;
        const equipament = await this.equipamentRepository.findOne({
            where: {
                id: equipId
            },
            relations: ['user'],
        });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado");
        }
        if (equipament.user?.id != id && user.roles != enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN) {
            throw new common_2.ForbiddenException("Erro de permissão. Seu usário não possui relação com esse equipamento \n ou privilégios administrativos");
        }
        let userExist;
        if (!(!updateEquipamentDto.sinc_code)) {
            userExist = await this.userRepository.findOneBy({ sinc_code: updateEquipamentDto.sinc_code });
            if (!userExist) {
                throw new common_2.NotFoundException("Código de sincronização inválido. \n Motivo: Não há nenhum usuário relacionado com esse código");
            }
            else if (!userExist.is_aproved) {
                throw new common_2.ForbiddenException("Código de sincronização inválido. \n Motivo: Usuário não aprovado");
            }
        }
        try {
            const equipamentUpdated = await this.equipamentRepository.update(equipament.id, {
                equipament_name: updateEquipamentDto.equipament_name,
                section: updateEquipamentDto.section,
                ...(userExist && { user: userExist })
            });
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar atualziar o equipamento");
        }
        return { message: "Equipamento atualizado com sucesso" };
    }
    async unlinkDeviceByUser(equipId, id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        const equipament = await this.equipamentRepository.findOne({
            where: {
                id: equipId,
            },
            relations: ['user'],
        });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado");
        }
        ;
        if (equipament.user?.id != user.id && user.roles != enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN) {
            throw new common_2.ForbiddenException("Erro de permissão. Seu usário não possui relação com esse equipamento \n ou privilégios administrativos");
        }
        try {
            await this.equipamentRepository.update(equipament.id, { user: null });
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar desvincular o usuário do equipamento");
        }
        return "Desvinculo realizado com sucesso";
    }
    async updateStatus(updateStatusDto) {
        const { mac_address, isOpen, hasAlert, cicle, operation_hours } = updateStatusDto;
        const equipament = await this.equipamentRepository.findOne({
            where: { mac_address },
            relations: ['door', 'fan', 'user'],
        });
        if (!equipament) {
            throw new common_2.NotFoundException('Equipamento não encontrado');
        }
        try {
            if (equipament.fan) {
                const fan = await this.industrialFanRepository.findOneBy({ id: equipament.fan.id });
                if (!fan) {
                    throw new common_2.NotFoundException('Ventilador associado ao equipamento não encontrado');
                }
                fan.operation_hours = operation_hours ?? fan.operation_hours;
                await this.industrialFanRepository.save(fan);
            }
            if (equipament.door) {
                const door = await this.doorsRepository.findOneBy({ id: equipament.door.id });
                if (!door) {
                    throw new common_2.NotFoundException('Porta associada ao equipamento não encontrada');
                }
                door.is_open = isOpen ?? door.is_open;
                door.has_alert = hasAlert ?? door.has_alert;
                door.cicles = cicle ?? door.cicles;
                await this.doorsRepository.save(door);
                if (equipament.user?.id) {
                    const userId = equipament.user.id;
                    const userEquipaments = await this.equipamentRepository.find({
                        where: { user: { id: userId } },
                        relations: ['door'],
                    });
                    const alertCount = userEquipaments.filter(e => e.door?.has_alert === true).length;
                    const equipId = equipament.id;
                    this.eventEmitter.emit('statusEquipChangeAdm', { userId, alertCount });
                    this.eventEmitter.emit('statusEquipChange', { userId, equipId, isOpen, hasAlert, cicle, date: new Date() });
                    this.needMaintananceOrNot(equipament.mac_address, equipament.equipament_name, equipament.user.cellphone, cicle ?? null, operation_hours ?? null);
                }
            }
            return 'Status atualizado';
        }
        catch (error) {
            throw new common_2.BadRequestException('Erro ao atualizar o status do equipamento: ' + error.message);
        }
    }
    async updateScheduleByEquipament(equipId, id, updateSchedulesDto) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        const equipament = await this.equipamentRepository.findOne({
            where: {
                id: equipId,
            },
            relations: ['fan', 'user'],
        });
        if (!equipament || !equipament.fan) {
            throw new common_2.NotFoundException("Equipamento não encontrado ou sem função de programação");
        }
        if (equipament.user?.id != id && user.roles != enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN) {
            throw new common_2.ForbiddenException("Erro de permissão. Seu usário não possui relação com esse equipamento \n ou privilégios administrativos");
        }
        if (updateSchedulesDto.on_at > updateSchedulesDto.off_at) {
            throw new common_2.BadRequestException("Horários inválidos. A hora inicial é maior do que a hora final");
        }
        try {
            const schedule = await this.scheduleRepository.update({ id: equipament.id }, updateSchedulesDto);
            console.log(schedule);
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar atualizar a programação. \n Erro: " + error.message);
        }
        return { message: "Programção armazenada com sucesso. \n Será enviada para o equipamento em breve" };
    }
    async updateScheduleByGroup(currentUserId, updateSchedulesByGroupDto) {
        const { groupId, ...updateSchedulesByGroup } = updateSchedulesByGroupDto;
        const group = await this.groupRepository.findOne({
            where: { id: groupId, user: { id: currentUserId } },
            relations: ['equipament', 'equipament.fan'],
        });
        if (!group) {
            throw new common_2.NotFoundException("Grupo de equipamentos não encontrado");
        }
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            for (const equipament of group.equipament) {
                if (!equipament.fan) {
                    console.log(`Equipamento ${equipament.id} não possui função de programação.`);
                    continue;
                }
                const existingSchedule = await queryRunner.manager.findOne(schedules_entity_1.Schedules, { where: { id: equipament.id } });
                if (existingSchedule) {
                    await queryRunner.manager.update(schedules_entity_1.Schedules, { id: equipament.id }, updateSchedulesByGroup);
                }
                else {
                    await queryRunner.manager.insert(schedules_entity_1.Schedules, { id: equipament.id, ...updateSchedulesByGroup });
                }
            }
            await queryRunner.commitTransaction();
            return { message: "Programação para o grupo armazenada com sucesso. Será enviada para os equipamentos em breve" };
        }
        catch (error) {
            await queryRunner.rollbackTransaction();
            throw new common_2.BadRequestException(`Erro ao tentar atualizar a programação para o grupo. \n Erro: ${error.message}`);
        }
        finally {
            await queryRunner.release();
        }
    }
    async removeEquipamentFromGroup(currentUserId, removeEquipamentFromGroupDto) {
        const { equipId, groupId } = removeEquipamentFromGroupDto;
        const equipament = await this.equipamentRepository.findOne({ where: { id: equipId, user: { id: currentUserId } } });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado ou não pertence ao usuário.");
        }
        const group = await this.groupRepository.findOne({
            where: {
                id: groupId,
                user: { id: currentUserId },
            },
        });
        if (!group) {
            throw new common_2.NotFoundException("Grupo não encontrado ou não pertence ao usuário.");
        }
        await this.equipamentRepository.update(equipament.id, { group: null });
        return { message: "Equipamento removido do grupo com sucesso." };
    }
    async remove(equipId, id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        ;
        const equipament = await this.equipamentRepository.findOne({
            where: {
                id: equipId
            },
            relations: ['user'],
        });
        if (!equipament) {
            throw new common_2.NotFoundException("Equipamento não encontrado");
        }
        if (equipament.user?.id != id && user.roles != enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN) {
            throw new common_2.ForbiddenException("Erro de permissão. Seu usário não possui relação com esse equipamento \n ou privilégios administrativos");
        }
        try {
            if (equipament.door) {
                await this.doorsRepository.delete({ id: equipament.id });
                equipament.door = null;
            }
            else if (equipament.fan) {
                await this.industrialFanRepository.delete({ id: equipament.id });
                equipament.fan = null;
            }
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar remover o equipamento(1). \n Erro: " + error.message);
        }
        try {
            await this.equipamentRepository.save(equipament);
            await this.equipamentRepository.remove(equipament);
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar remover o equipamento(2). \n Erro: " + error.message);
        }
        return "Equipamento removido com sucesso";
    }
    updateOnCreate(dto, equipamentExist, userId) {
        const equipamentUpdated = this.equipamentRepository.merge(equipamentExist, {
            ...dto,
            user: { id: userId },
        });
        return this.equipamentRepository.save(equipamentUpdated);
    }
    async getEquips(id) {
        const getEquipaments = await this.equipamentRepository
            .createQueryBuilder("equipaments")
            .leftJoinAndMapOne("equipaments.door", door_entity_1.Door, "door", "door.id = equipaments.id")
            .leftJoinAndMapOne("equipaments.fan", industrial_fan_entity_1.IndustrialFan, "fan", "fan.id = equipaments.id")
            .where("equipaments.user.id = :id", { id })
            .getMany();
        console.log(getEquipaments);
        const filteredEquipaments = getEquipaments.map(equip => {
            const result = equip;
            if (!equip.door)
                delete result.door;
            if (!equip.fan)
                delete result.fan;
            return result;
        });
        return filteredEquipaments;
    }
    async countInfoCards(userId) {
        const getEquipaments = await this.equipamentRepository
            .createQueryBuilder("equipaments")
            .leftJoinAndMapOne("equipaments.door", door_entity_1.Door, "door", "door.id = equipaments.id")
            .where("equipaments.user.id = :id", { id: userId })
            .getMany();
        return getEquipaments.filter(e => e.door && e.door.has_alert === true).length;
    }
    async updateUserCards(userId, type) {
        const totalEquipaments = await this.countAllByUser(userId);
        const totalDoors = await this.countByType("porta", userId);
        const totalFans = await this.countByType("ventilador", userId);
        const totalAlert = await this.countInfoCards(userId);
        return { userId, totalEquipaments, totalDoors, totalFans, totalAlert };
    }
    async needMaintananceOrNot(macAddress, equipName, userCellphone, cicle, operation_hours) {
        if (cicle) {
            const digitCount = Math.abs(cicle).toString().length;
            const divisor = Math.pow(10, digitCount - 1);
            console.log("Digito: ", digitCount);
            console.log("Divisor: ", divisor);
            console.log(cicle / divisor);
            if (cicle / divisor === 1) {
                this.eventEmitter.emit('need.maintanance', {
                    cellphone: userCellphone,
                    message: `Olá!\nSeu equipamento de nome ${equipName}, MAC: ${macAddress}, chegou a contagem de ${cicle} ciclos!\nAo chegar nesse marco recomendamos que seja agendada uma manutenção preventiva`
                });
            }
        }
    }
};
exports.EquipamentsService = EquipamentsService;
exports.EquipamentsService = EquipamentsService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(equipament_entity_1.Equipament)),
    __param(1, (0, typeorm_2.InjectRepository)(door_entity_1.Door)),
    __param(2, (0, typeorm_2.InjectRepository)(user_entity_1.User)),
    __param(3, (0, typeorm_2.InjectRepository)(model_entity_1.Model)),
    __param(4, (0, typeorm_2.InjectRepository)(watcher_entity_1.Watcher)),
    __param(5, (0, typeorm_2.InjectRepository)(industrial_fan_entity_1.IndustrialFan)),
    __param(6, (0, typeorm_2.InjectRepository)(schedules_entity_1.Schedules)),
    __param(7, (0, typeorm_2.InjectRepository)(group_entity_1.Group)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        doors_service_1.DoorsService,
        industrial_fans_service_1.IndustrialFansService,
        event_emitter_1.EventEmitter2,
        typeorm_1.DataSource])
], EquipamentsService);
//# sourceMappingURL=equipaments.service.js.map