import { Equipament } from 'src/visoflex360/equipaments/entities/equipament.entity';
import { DataSource, Repository } from 'typeorm';
import { CreateEquipamentDto, CreateEquipamentFirstConnectionDto } from './dto/create-equipament.dto';
import { Door } from 'src/visoflex360/doors/entities/door.entity';
import { DoorsService } from 'src/visoflex360/doors/doors.service';
import { IndustrialFan } from '../industrial_fans/entities/industrial_fan.entity';
import { IndustrialFansService } from 'src/visoflex360/industrial_fans/industrial_fans.service';
import { UpdateEquipamentDto, UpdateSchedulesByGroupDto, UpdateSchedulesDto, UpdateStatusDto } from './dto/update-equipament.dto';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { User } from 'src/shared/users/entities/user.entity';
import { Model } from 'src/visoflex360/models/entities/model.entity';
import { Watcher } from 'src/visoflex360/watchers/entities/watcher.entity';
import { Schedules } from 'src/visoflex360/equipaments/entities/schedules.entity';
import { AddEquipamentToGroupDto } from './dto/add-equipament-to-group.dto';
import { Group } from '../group/entities/group.entity';
export declare class EquipamentsService {
    private equipamentRepository;
    private doorsRepository;
    private userRepository;
    private modelRepository;
    private watcherRepository;
    private industrialFanRepository;
    private scheduleRepository;
    private groupRepository;
    private doorsService;
    private industrialFanService;
    private eventEmitter;
    private dataSource;
    constructor(equipamentRepository: Repository<Equipament>, doorsRepository: Repository<Door>, userRepository: Repository<User>, modelRepository: Repository<Model>, watcherRepository: Repository<Watcher>, industrialFanRepository: Repository<IndustrialFan>, scheduleRepository: Repository<Schedules>, groupRepository: Repository<Group>, doorsService: DoorsService, industrialFanService: IndustrialFansService, eventEmitter: EventEmitter2, dataSource: DataSource);
    createFirstConnection(createEquipamentDto: CreateEquipamentFirstConnectionDto): Promise<any>;
    addEquipamentToGroup(currentUserId: number, addEquipamentToGroupDto: AddEquipamentToGroupDto): Promise<{
        message: string;
    }>;
    countAll(): Promise<number>;
    findAll(): Promise<Equipament[]>;
    ping(mac: string): Promise<{
        message: string;
        more: any;
    }>;
    findSchedulesByEquipament(equipId: number, id: number): Promise<Schedules>;
    findMonitoredEquipaments(id: number): Promise<any[]>;
    countAllByUser(userId: number): Promise<number>;
    countForCards(): Promise<{
        totalEquipaments: number;
        totalDoors: number;
        totalFans: number;
    }>;
    findAllByUser(id: number): Promise<{
        id: number;
        equipament_name: string;
        internal_id: string;
        section: string;
        created_at: Date;
        latest_maintanence: Date;
        door?: Door;
        fan?: IndustrialFan;
    }[]>;
    findOne(id: number, type: string): Promise<any>;
    countByType(type: string, userId?: number): Promise<number>;
    update(equipId: number, id: number, updateEquipamentDto: UpdateEquipamentDto): Promise<{
        message: string;
    }>;
    unlinkDeviceByUser(equipId: number, id: number): Promise<string>;
    updateStatus(updateStatusDto: UpdateStatusDto): Promise<string>;
    updateScheduleByEquipament(equipId: number, id: number, updateSchedulesDto: UpdateSchedulesDto): Promise<{
        message: string;
    }>;
    updateScheduleByGroup(currentUserId: number, updateSchedulesByGroupDto: UpdateSchedulesByGroupDto): Promise<{
        message: string;
    }>;
    removeEquipamentFromGroup(currentUserId: number, removeEquipamentFromGroupDto: AddEquipamentToGroupDto): Promise<{
        message: string;
    }>;
    remove(equipId: number, id: number): Promise<string>;
    updateOnCreate(dto: CreateEquipamentDto, equipamentExist: any, userId: number): Promise<Equipament>;
    getEquips(id: number): Promise<{
        id: number;
        equipament_name: string;
        internal_id: string;
        section: string;
        created_at: Date;
        latest_maintanence: Date;
        door?: Door;
        fan?: IndustrialFan;
    }[]>;
    countInfoCards(userId: number): Promise<number>;
    updateUserCards(userId: number, type?: string): Promise<{
        userId: number;
        totalEquipaments: number;
        totalDoors: number;
        totalFans: number;
        totalAlert: number;
    }>;
    needMaintananceOrNot(macAddress: any, equipName: any, userCellphone: any, cicle: number | null, operation_hours: number | null): Promise<void>;
}
