"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShoppingCartController = void 0;
const common_2 = require("@nestjs/common");
const shopping_cart_service_1 = require("./shopping_cart.service");
const add_item_from_cart__dto_1 = require("./dto/add-item-from-cart-.dto");
const update_shopping_cart_dto_1 = require("./dto/update-shopping_cart.dto");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
let ShoppingCartController = class ShoppingCartController {
    shoppingCartService;
    constructor(shoppingCartService) {
        this.shoppingCartService = shoppingCartService;
    }
    addItemFromCart(currentUser, addItemFromCart) {
        return this.shoppingCartService.addItemFromCart(currentUser, addItemFromCart);
    }
    getCartContents(currentUser) {
        return this.shoppingCartService.getCartContents(currentUser);
    }
    countTotalItemsInOpenOrder(currentUser) {
        return this.shoppingCartService.countTotalItemsInOpenOrder(currentUser);
    }
    updateItemQuantityInCart(currentUser, updateItemFromCart) {
        return this.shoppingCartService.updateItemQuantityInCart(currentUser, updateItemFromCart);
    }
    removeItemFromCart(currentUser, removeItemFromCart) {
        return this.shoppingCartService.removeItemFromCart(currentUser, removeItemFromCart);
    }
};
exports.ShoppingCartController = ShoppingCartController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, add_item_from_cart__dto_1.AddItemFromCartDto]),
    __metadata("design:returntype", void 0)
], ShoppingCartController.prototype, "addItemFromCart", null);
__decorate([
    (0, common_2.Get)('/me'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], ShoppingCartController.prototype, "getCartContents", null);
__decorate([
    (0, common_2.Get)('/total-itens'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], ShoppingCartController.prototype, "countTotalItemsInOpenOrder", null);
__decorate([
    (0, common_2.Patch)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, update_shopping_cart_dto_1.UpdateShoppingCartDto]),
    __metadata("design:returntype", void 0)
], ShoppingCartController.prototype, "updateItemQuantityInCart", null);
__decorate([
    (0, common_2.Delete)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, update_shopping_cart_dto_1.RemoveItemFromCartDto]),
    __metadata("design:returntype", void 0)
], ShoppingCartController.prototype, "removeItemFromCart", null);
exports.ShoppingCartController = ShoppingCartController = __decorate([
    (0, common_2.Controller)('carrinho'),
    __metadata("design:paramtypes", [shopping_cart_service_1.ShoppingCartService])
], ShoppingCartController);
//# sourceMappingURL=shopping_cart.controller.js.map