import { ShoppingCartService } from './shopping_cart.service';
import { AddItemFromCartDto } from './dto/add-item-from-cart-.dto';
import { RemoveItemFromCartDto, UpdateShoppingCartDto } from './dto/update-shopping_cart.dto';
export declare class ShoppingCartController {
    private readonly shoppingCartService;
    constructor(shoppingCartService: ShoppingCartService);
    addItemFromCart(currentUser: any, addItemFromCart: AddItemFromCartDto): Promise<{
        message: string;
    }>;
    getCartContents(currentUser: any): Promise<{
        message: string;
        order?: undefined;
    } | {
        order: {
            id: number;
            status: import("../../shared/enums/enum").Status;
            total_items: number;
            cupom: import("../cupom/entities/cupom.entity").Cupom;
            subtotal: number;
            total_amount: number;
            discount_applied: number;
            items: {
                id: number;
                name: string;
                description: string;
                image: string;
                quantity: number;
                price: number;
                quantity_in_stock: number;
            }[];
        };
        message?: undefined;
    }>;
    countTotalItemsInOpenOrder(currentUser: any): Promise<{
        total_quantity: any;
    }>;
    updateItemQuantityInCart(currentUser: any, updateItemFromCart: UpdateShoppingCartDto): Promise<{
        message: string;
    }>;
    removeItemFromCart(currentUser: any, removeItemFromCart: RemoveItemFromCartDto): Promise<{
        message: string;
    }>;
}
