"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportsService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const order_entity_1 = require("../../../orders/entities/order.entity");
const enum_1 = require("../../../../shared/enums/enum");
const user_entity_1 = require("../../../../shared/users/entities/user.entity");
let ReportsService = class ReportsService {
    orderRepository;
    userRepository;
    constructor(orderRepository, userRepository) {
        this.orderRepository = orderRepository;
        this.userRepository = userRepository;
    }
    async getOrdersPerHour(date) {
        if (!date) {
            date = new Date().toISOString().slice(0, 10);
        }
        if (!/^\d{4}-\d{2}-\d{2}$/.test(date)) {
            throw new common_2.BadRequestException('Data inválida. Use o formato YYYY-MM-DD');
        }
        const fullHours = Array.from({ length: 24 }, (_, i) => ({
            hour: `${i.toString().padStart(2, '0')}:00`,
            total: 0,
        }));
        const results = await this.orderRepository
            .createQueryBuilder('order')
            .select(`DATE_FORMAT(order.updated_at, '%H:00')`, 'hour')
            .addSelect('COUNT(*)', 'total')
            .where('DATE(order.updated_at) = :date', { date })
            .andWhere('order.status = :status', { status: enum_1.Status.PAID })
            .groupBy('hour')
            .orderBy('hour', 'ASC')
            .getRawMany();
        const merged = fullHours.map(h => {
            const found = results.find(r => r.hour === h.hour);
            return {
                hour: h.hour,
                total: found ? Number(found.total) : 0,
            };
        });
        return merged;
    }
    async findAllClients() {
        const lastOrderSubQuery = this.userRepository.manager.createQueryBuilder()
            .select('MAX(subOrder.id)', 'lastOrderId')
            .from('order', 'subOrder')
            .where('subOrder.userId = user.id')
            .andWhere('subOrder.status IN (:...statuses)', { statuses: [enum_1.Status.FINISHED, enum_1.Status.PAID] });
        const users = await this.userRepository
            .createQueryBuilder('user')
            .innerJoin('user.order', 'order')
            .where(`order.id = (${lastOrderSubQuery.getQuery()})`)
            .setParameters(lastOrderSubQuery.getParameters())
            .select([
            'user.id',
            'user.document',
            'user.company_name',
            'user.user_name',
            'user.email',
            'user.cellphone',
        ])
            .getMany();
        return users;
    }
    async getCardsInfo() {
        const totalOrders = +await this.countTotalOrders();
        const totalAmount = await this.countTotalAmountOrders();
        return {
            totalOrders: totalOrders || 0,
            totalAmount: +totalAmount || 0,
            averageTicket: (totalAmount > 0) ? totalAmount / totalOrders : 0
        };
    }
    async countTotalAmount() {
        const today = new Date();
        const dateFormated = today.toISOString().split('T')[0];
        const dataByStores = await this.orderRepository
            .createQueryBuilder('order')
            .select('COUNT(DISTINCT(order.id))', 'totalOrders')
            .addSelect('SUM(order.total_amount)', 'totalAmount')
            .andWhere('order.status = :status', { status: enum_1.Status.PAID })
            .andWhere('DATE(order.updated_at) = :date', { date: dateFormated })
            .getRawOne();
        const totalOrders = dataByStores.totalOrders || 0;
        const totalAmount = dataByStores.totalAmount || 0;
        return { totalOrders, totalAmount };
    }
    async getDetailsByOrderId(orderId) {
        const orders = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoinAndSelect('order.user', 'user')
            .innerJoinAndSelect('order.order_product', 'orderProduct')
            .innerJoinAndSelect('orderProduct.product', 'product')
            .where('order.id = :orderId', { orderId })
            .getMany();
        const formattedOrders = orders.map(order => ({
            id: order.id,
            status: order.status,
            total_items: order.order_product.reduce((sum, item) => sum + item.quantity, 0),
            total_amount: order.total_amount,
            created_at: order.created_at,
            updated_at: order.updated_at,
            payment_method: order.payment_method,
            paymentId: order.paymentId,
            order_product: order.order_product.map(product => ({
                id: product.id,
                quantity: product.quantity,
                unit_price: product.unit_price,
                product: {
                    id: product.product.id,
                    cod_factory: product.product.cod_product,
                    name: product.product.name,
                    description: product.product.description,
                    image: product.product.image,
                    line: product.product.line,
                    category: product.product.category,
                },
            })),
        }));
        return formattedOrders;
    }
    async getFinishedOrders() {
        const orders = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoinAndSelect('order.user', 'user')
            .innerJoinAndSelect('order.order_product', 'orderProduct')
            .innerJoinAndSelect('orderProduct.product', 'product')
            .where('order.status = :status', { status: enum_1.Status.PAID })
            .getMany();
        const formattedOrders = orders.map(order => ({
            id: order.id,
            status: order.status,
            total_items: order.order_product.reduce((sum, item) => sum + item.quantity, 0),
            total_amount: order.total_amount,
            created_at: order.created_at,
            updated_at: order.updated_at,
            payment_method: order.payment_method,
            paymentId: order.paymentId,
            order_product: order.order_product.map(item => ({
                id: item.id,
                quantity: item.quantity,
                unit_price: item.unit_price,
                product: {
                    id: item.product.id,
                    cod_factory: item.product.cod_product,
                    name: item.product.name,
                    description: item.product.description,
                    image: item.product.image,
                    line: item.product.line,
                    category: item.product.category,
                },
            })),
        }));
        return formattedOrders;
    }
    async getTopProductsPerDay() {
        const today = new Date();
        const dateFormated = today.toISOString().split('T')[0];
        const topProducts = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.order_product', 'orderProduct')
            .innerJoin('orderProduct.product', 'product')
            .select('product.name', 'name')
            .addSelect('product.image', 'image')
            .addSelect('product.id', 'id')
            .addSelect('product.price', 'price')
            .addSelect('SUM(orderProduct.quantity)', 'totalQuantitySold')
            .where('DATE(order.updated_at) = :date', { date: dateFormated })
            .andWhere('order.status IN (:...statuses)', {
            statuses: [enum_1.Status.PAID, enum_1.Status.FINISHED],
        })
            .groupBy('product.id')
            .addGroupBy('product.name')
            .addGroupBy('product.image')
            .addGroupBy('product.price')
            .orderBy('totalQuantitySold', 'DESC')
            .limit(5)
            .getRawMany();
        return topProducts.map(p => ({
            id: p.id,
            name: p.name,
            image: p.image,
            price: Number(p.price),
            totalQuantitySold: Number(p.totalQuantitySold),
        }));
    }
    async countTotalOrders() {
        const today = new Date();
        const dateFormated = today.toISOString().split('T')[0];
        const totalOrders = await this.orderRepository
            .createQueryBuilder('order')
            .select('COUNT(DISTINCT order.id)', 'total')
            .where('order.status = :status', { status: enum_1.Status.PAID })
            .andWhere('DATE(order.updated_at) = :date', { date: dateFormated })
            .getRawOne();
        return totalOrders.total;
    }
    async percentComplete() {
        const today = new Date();
        const dateFormated = today.toISOString().split('T')[0];
        const orders = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.store', 'store')
            .innerJoin('store.store_association', 'store_association')
            .select('order.status')
            .where('DATE(order.created_at) = :date', { date: dateFormated })
            .andWhere('order.status = :status', { status: enum_1.Status.FINISHED })
            .getRawMany();
        const totalOrdersDelivereds = orders
            .filter(order => order.order_status === enum_1.Status.FINISHED).length;
        const result = (totalOrdersDelivereds * 100) / orders.length;
        return result;
    }
    async countTotalAmountOrders() {
        const today = new Date();
        const dateFormated = today.toISOString().split('T')[0];
        const totalOrders = await this.orderRepository
            .createQueryBuilder('order')
            .select('SUM(order.total_amount)', 'total')
            .where('order.status = :status', { status: enum_1.Status.PAID })
            .andWhere('DATE(order.updated_at) = :date', { date: dateFormated })
            .getRawOne();
        return totalOrders.total;
    }
};
exports.ReportsService = ReportsService;
exports.ReportsService = ReportsService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ReportsService);
//# sourceMappingURL=reports.service.js.map