import { CreateProductDto } from './dto/create-product.dto';
import { UpdateProductDto } from './dto/update-product.dto';
import { Product } from './entities/product.entity';
import { Repository } from 'typeorm';
export declare class ProductsService {
    private productRepository;
    constructor(productRepository: Repository<Product>);
    private s3;
    create(createProductDto: CreateProductDto): Promise<Product>;
    findAll(): Promise<Product[]>;
    findAllForManagement(): Promise<Product[]>;
    findOneForManagement(): Promise<Product[]>;
    findOne(productId: number): Promise<Product>;
    update(productId: number, updateProductDto: UpdateProductDto): Promise<{
        message: string;
    }>;
    remove(productId: number): Promise<{
        message: string;
    }>;
    findProductById(productId: number): Promise<Product>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
}
