import { User } from 'src/shared/users/entities/user.entity';
import { Repository } from 'typeorm';
import { Order } from './entities/order.entity';
import { OrderProduct } from 'src/ecommerce/orders/entities/order_product.entity';
import { OrderTransactions } from './entities/order_transaction.entity';
import { Status } from 'src/shared/enums/enum';
import { AsaasService } from 'src/ecommerce/asaas/asaas.service';
import { CheckoutDto } from './dto/checkout.dto';
import { UsersService } from 'src/shared/users/users.service';
import { Product } from '../products/entities/product.entity';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { MailerService } from '@nestjs-modules/mailer';
import { Creditcard } from '../creditcard/entities/creditcard.entity';
export declare class OrdersService {
    private orderRepository;
    private userRepository;
    private orderProductRepository;
    private orderTransactionsRepository;
    private productRepository;
    private creditcardRepository;
    private readonly asaasService;
    private readonly usersService;
    private readonly eventEmitter;
    private readonly mailerService;
    constructor(orderRepository: Repository<Order>, userRepository: Repository<User>, orderProductRepository: Repository<OrderProduct>, orderTransactionsRepository: Repository<OrderTransactions>, productRepository: Repository<Product>, creditcardRepository: Repository<Creditcard>, asaasService: AsaasService, usersService: UsersService, eventEmitter: EventEmitter2, mailerService: MailerService);
    findAllByUser(currentUserId: number): Promise<Order[] | {
        message: string;
    }>;
    findAllProductsByOrderId(currentUserId: number, orderId: number): Promise<Order>;
    findAll(): Promise<Order[]>;
    findAllByStatus(status: Status): Promise<Order[]>;
    restrictFindAllProductsByOrderId(orderId: number): Promise<Order[]>;
    checkout(currentUserId: number, checkoutDto: CheckoutDto): Promise<{
        paymentId: string;
        qrCode: string;
        copyPaste: string;
    } | undefined>;
    createQRcode(currentUserId: number): Promise<{
        qrcode: any;
        paymentId: string;
    }>;
    statusPaied(paymentId: string): Promise<Order[] | "não pago">;
    changeOrderStatusById(id: number, status: Status): Promise<{
        message: string;
    }>;
    enviarEmailPedidoCriado(order: any): Promise<string>;
    findShoppingCartByUser(userId: number): Promise<{
        id: any;
        status: any;
        total_amount: any;
        total_items: any;
        user_id: any;
        products: {
            id: any;
            quantity: any;
            unit_price: any;
        }[];
    } | null>;
    findOrderById(orderId: number): Promise<OrderProduct[]>;
    verifyStock(orderId: {
        orderId: number;
    }): Promise<void>;
}
