import { OrdersService } from './orders.service';
import { Status } from 'src/shared/enums/enum';
import { CheckoutDto } from './dto/checkout.dto';
export declare class OrdersController {
    private readonly ordersService;
    constructor(ordersService: OrdersService);
    findAllByUser(currentUser: any): Promise<import("./entities/order.entity").Order[] | {
        message: string;
    }>;
    findAllProductsByOrderId(orderId: string, currentUser: any): Promise<import("./entities/order.entity").Order>;
    findAll(): Promise<import("./entities/order.entity").Order[]>;
    findAllByStatus(status: Status): Promise<import("./entities/order.entity").Order[]>;
    restrictFindAllProductsByOrderId(orderId: string): Promise<import("./entities/order.entity").Order[]>;
    createQRcode(currentUser: any): Promise<{
        qrcode: any;
        paymentId: string;
    }>;
    statusPaied(paymentId: string): Promise<import("./entities/order.entity").Order[] | "não pago">;
    checkout(currentUser: any, chechkoutDto: CheckoutDto): Promise<{
        paymentId: string;
        qrCode: string;
        copyPaste: string;
    } | undefined>;
    changeOrderStatusById(orderId: string, status: Status): Promise<{
        message: string;
    }>;
}
