"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreditcardController = void 0;
const common_2 = require("@nestjs/common");
const creditcard_service_1 = require("./creditcard.service");
const create_creditcard_dto_1 = require("./dto/create-creditcard.dto");
const update_creditcard_dto_1 = require("./dto/update-creditcard.dto");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
let CreditcardController = class CreditcardController {
    creditcardService;
    constructor(creditcardService) {
        this.creditcardService = creditcardService;
    }
    create(createCreditcardDto, currentUser) {
        return this.creditcardService.create(createCreditcardDto, currentUser);
    }
    findAll(currentUser) {
        return this.creditcardService.findAll(currentUser);
    }
    finfindLastCardRegisterdOne(currentUser) {
        return this.creditcardService.findLastCardRegister(currentUser);
    }
    update(id, updateCreditcardDto) {
        return this.creditcardService.update(+id, updateCreditcardDto);
    }
    remove(id) {
        return this.creditcardService.remove(+id);
    }
};
exports.CreditcardController = CreditcardController;
__decorate([
    (0, common_2.Post)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_creditcard_dto_1.CreateCreditcardDto, Object]),
    __metadata("design:returntype", void 0)
], CreditcardController.prototype, "create", null);
__decorate([
    (0, common_2.Get)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], CreditcardController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('last'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], CreditcardController.prototype, "finfindLastCardRegisterdOne", null);
__decorate([
    (0, common_2.Patch)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_creditcard_dto_1.UpdateCreditcardDto]),
    __metadata("design:returntype", void 0)
], CreditcardController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CreditcardController.prototype, "remove", null);
exports.CreditcardController = CreditcardController = __decorate([
    (0, common_2.Controller)('creditcard'),
    __metadata("design:paramtypes", [creditcard_service_1.CreditcardService])
], CreditcardController);
//# sourceMappingURL=creditcard.controller.js.map