"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Course_paymentController = void 0;
const common_2 = require("@nestjs/common");
const course_payment_service_1 = require("./course_payment.service");
const create_course_payment_dto_1 = require("./dto/create-course_payment.dto");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const asaas_service_1 = require("../asaas/asaas.service");
let Course_paymentController = class Course_paymentController {
    course_paymentService;
    asaasService;
    constructor(course_paymentService, asaasService) {
        this.course_paymentService = course_paymentService;
        this.asaasService = asaasService;
    }
    create(currentUser, id, createChargeDto) {
        return this.course_paymentService.create(currentUser.id, id, createChargeDto);
    }
    async confirmPayment(paymentId) {
        return await this.course_paymentService.confirmPayment(paymentId);
    }
    getQrCode(currentUser) {
        return this.course_paymentService.getQrCode(currentUser.id);
    }
};
exports.Course_paymentController = Course_paymentController;
__decorate([
    (0, common_2.Post)('/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Param)('id')),
    __param(2, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number, create_course_payment_dto_1.CreateCourse_paymentDto]),
    __metadata("design:returntype", void 0)
], Course_paymentController.prototype, "create", null);
__decorate([
    (0, common_2.Get)(':paymentId'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('paymentId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], Course_paymentController.prototype, "confirmPayment", null);
__decorate([
    (0, common_2.Get)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], Course_paymentController.prototype, "getQrCode", null);
exports.Course_paymentController = Course_paymentController = __decorate([
    (0, common_2.Controller)('course_payment'),
    __metadata("design:paramtypes", [course_payment_service_1.Course_paymentService,
        asaas_service_1.AsaasService])
], Course_paymentController);
//# sourceMappingURL=course_payment.controller.js.map