import { CreatePostDto } from './dto/create-post.dto';
import { UpdatePostDto } from './dto/update-post.dto';
import { Post } from './entities/post.entity';
import { Repository } from 'typeorm';
import { CreateComentarioDto } from './dto/create-comentario.dto';
import { Comentario } from './entities/comentario.entity';
import { User } from 'src/shared/users/entities/user.entity';
import { PostInteration } from './entities/postInteration.entity';
import { CourseService } from 'src/ecommerce/courses/courses.service';
import { AgendaService } from '../agenda/agenda.service';
export declare class PostService {
    private postRepository;
    private comentarioRepository;
    private postInterationRepository;
    private readonly courseService;
    private readonly agendaService;
    constructor(postRepository: Repository<Post>, comentarioRepository: Repository<Comentario>, postInterationRepository: Repository<PostInteration>, courseService: CourseService, agendaService: AgendaService);
    private s3;
    create(createPostDto: CreatePostDto, currentUser: User, imagem?: Express.Multer.File): Promise<Post>;
    findAll(currentUser: User): Promise<Post[] | {
        posts: Post[];
        course: any[];
        courseProgress: any[];
        agendamentos: import("../agenda/entities/agenda.entity").Agenda[];
    }>;
    findOne(id: number, currentUser: User): Promise<{
        comentarios: any[];
        interacaoPost: any[];
        id: number;
        titulo: String;
        subtitulo: String;
        corpo: String;
        data: Date;
        views: number;
        like: number;
        deslike: number;
        url: string;
        categoria: string;
        tipo: string;
        user: User;
        comentario: Comentario[];
        postInteration: PostInteration[];
    } | null>;
    private buildTree;
    getComentarios(postId: number): Promise<any[]>;
    like(id: number, currentUser: User): Promise<string>;
    deslike(id: number, currentUser: User): Promise<string>;
    createComentario(createComentarioDto: CreateComentarioDto, currentUser: User, postId: number): Promise<Comentario>;
    update(id: number, updatePostDto: UpdatePostDto): Promise<import("typeorm").UpdateResult>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
    removeComentario(idComentario: number): Promise<import("typeorm").DeleteResult>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
}
