"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilesController = void 0;
const common_2 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
const fs = require("fs");
const path_1 = require("path");
const files_service_1 = require("./files.service");
const create_files_dto_1 = require("./dto/create-files.dto");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const enum_1 = require("../../shared/enums/enum");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const swagger_2 = require("@nestjs/swagger");
const create_path_dto_1 = require("./dto/create-path.dto");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const update_path_dto_1 = require("./dto/update-path.dto");
let FilesController = class FilesController {
    filesService;
    constructor(filesService) {
        this.filesService = filesService;
    }
    async create(file, data) {
        const parsedData = JSON.parse(data);
        const dto = (0, class_transformer_1.plainToInstance)(create_files_dto_1.CreateFilesDto, parsedData);
        await (0, class_validator_1.validateOrReject)(dto);
        return this.filesService.create(file, dto);
    }
    createFolder(createFolderDto) {
        console.log("CONTROLLER CHAMADO");
        return this.filesService.createFolder(createFolderDto);
    }
    getRaiz(currentUser) {
        return this.filesService.getRaiz(currentUser);
    }
    getRelation(id, currentUser) {
        return this.filesService.getRelation(id, currentUser);
    }
    editPath(id, updateFolderDto) {
        return this.filesService.editPath(id, updateFolderDto);
    }
    async delete(id) {
        return this.filesService.deleteFolder(id);
    }
    async downloadFile(id, res) {
        const filePath = await this.filesService.getFilePath(id);
        const fullPath = (0, path_1.join)(filePath);
        return res.download(fullPath);
    }
    async viewImage(id, res) {
        const filePath = await this.filesService.getFilePath(id);
        const fullPath = (0, path_1.join)(filePath);
        return res.sendFile(fullPath);
    }
    findAll() {
        return this.filesService.findAll();
    }
    remove(id) {
        return this.filesService.remove(+id);
    }
};
exports.FilesController = FilesController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: (0, multer_1.diskStorage)({
            destination: (req, file, cb) => {
                const rawData = req.body['data'] ? JSON.parse(req.body['data']) : {};
                const pathFromUser = rawData.path || '';
                const uploadPath = './uploads';
                const fullPath = (0, path_1.join)(process.cwd(), uploadPath, pathFromUser);
                fs.mkdirSync(fullPath, { recursive: true });
                cb(null, fullPath);
            },
            filename: (req, file, cb) => {
                const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1e9);
                const ext = (0, path_1.extname)(file.originalname);
                cb(null, `${file.fieldname}-${uniqueSuffix}${ext}`);
            },
        }),
    })),
    __param(0, (0, common_2.UploadedFile)()),
    __param(1, (0, common_2.Body)('data')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "create", null);
__decorate([
    (0, common_2.Post)('/pasta'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_path_dto_1.CreateFolderDto]),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "createFolder", null);
__decorate([
    (0, common_2.Get)('/pasta'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "getRaiz", null);
__decorate([
    (0, common_2.Get)('/pasta/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "getRelation", null);
__decorate([
    (0, common_2.Patch)('/pasta/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_path_dto_1.UpdatePathDto]),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "editPath", null);
__decorate([
    (0, common_2.Delete)('/delete/pasta/:id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "delete", null);
__decorate([
    (0, common_2.Get)('donwload/:id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "downloadFile", null);
__decorate([
    (0, common_2.Get)(':id/view'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "viewImage", null);
__decorate([
    (0, common_2.Get)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "findAll", null);
__decorate([
    (0, common_2.Delete)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FilesController.prototype, "remove", null);
exports.FilesController = FilesController = __decorate([
    (0, swagger_2.ApiTags)('Arquivos'),
    (0, common_2.Controller)('arquivos'),
    __metadata("design:paramtypes", [files_service_1.FilesService])
], FilesController);
//# sourceMappingURL=files.controller.js.map