"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentsGateway = void 0;
const websockets_1 = require("@nestjs/websockets");
const socket_io_1 = require("socket.io");
const equipaments_service_1 = require("./equipaments.service");
const event_emitter_1 = require("@nestjs/event-emitter");
let EquipamentsGateway = class EquipamentsGateway {
    equipamentsService;
    constructor(equipamentsService) {
        this.equipamentsService = equipamentsService;
    }
    server;
    async handleUpdateUserCardsID(data) {
        this.updateUserCards(data.userId);
    }
    async updateUserCards(userId) {
        this.server.to(`user-${userId}`).emit('updateUserCards', await this.equipamentsService.updateUserCards(userId));
        this.server.to('admin').emit('updateUserCards', await this.equipamentsService.updateUserCards(userId));
    }
    statusEquipChangeAdm({ userId, alertCount }) {
        this.server.to('admin').emit('statusEquipChangeAdm', { userId, alertCount });
    }
    statusEquipChange({ userId, equipId, isOpen, hasAlert, cicles, date }) {
        this.server.to(`user-${userId}`).emit('statusEquipChange');
        this.server.to('admin').emit('statusEquipChange', { userId, equipId, isOpen, hasAlert, cicles, date });
    }
};
exports.EquipamentsGateway = EquipamentsGateway;
__decorate([
    (0, websockets_1.WebSocketServer)(),
    __metadata("design:type", socket_io_1.Server)
], EquipamentsGateway.prototype, "server", void 0);
__decorate([
    (0, websockets_1.SubscribeMessage)('receiveId'),
    __param(0, (0, websockets_1.MessageBody)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], EquipamentsGateway.prototype, "handleUpdateUserCardsID", null);
__decorate([
    (0, event_emitter_1.OnEvent)('receiveId'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], EquipamentsGateway.prototype, "updateUserCards", null);
__decorate([
    (0, event_emitter_1.OnEvent)('statusEquipChangeAdm'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], EquipamentsGateway.prototype, "statusEquipChangeAdm", null);
__decorate([
    (0, event_emitter_1.OnEvent)('statusEquipChange'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], EquipamentsGateway.prototype, "statusEquipChange", null);
exports.EquipamentsGateway = EquipamentsGateway = __decorate([
    (0, websockets_1.WebSocketGateway)(),
    __metadata("design:paramtypes", [equipaments_service_1.EquipamentsService])
], EquipamentsGateway);
//# sourceMappingURL=equipaments.gateway.js.map