"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateEquipamentFirstConnectionDto = exports.CreateEquipamentDto = void 0;
const swagger_2 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const model_entity_1 = require("../../models/entities/model.entity");
const user_entity_1 = require("../../../shared/users/entities/user.entity");
class CreateEquipamentDto {
    equipament_name;
    internal_id;
    model;
    section;
    user;
}
exports.CreateEquipamentDto = CreateEquipamentDto;
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Nome do equipamento', example: 'Porta Fast V5' }),
    (0, class_validator_1.IsString)({ message: "O nome do equipamento deve conter apenas texto" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O nome do equipamento é obrigatório" }),
    __metadata("design:type", String)
], CreateEquipamentDto.prototype, "equipament_name", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'ID interno do equipamento (o número do MAC)', example: '00:1A:2B:3C:4D:5E' }),
    (0, class_validator_1.IsString)({ message: "O ID do equipamento deve conter apenas texto" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O ID do equipamento é obrigatório" }),
    __metadata("design:type", String)
], CreateEquipamentDto.prototype, "internal_id", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Modelo do equipamento', type: model_entity_1.Model, required: true, example: 1 }),
    (0, class_validator_1.IsNotEmpty)({ message: "O modelo do equipamento é obrigatório" }),
    (0, class_validator_1.IsNumber)({}, { message: "O modelo do equipamento deve ser um número" }),
    __metadata("design:type", model_entity_1.Model)
], CreateEquipamentDto.prototype, "model", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Setor do equipamento', example: 'Estoque de Produtos Acabados' }),
    (0, class_validator_1.IsString)({ message: "O setor do equipamento deve conter apenas texto" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O setor do equipamento é obrigatório" }),
    __metadata("design:type", String)
], CreateEquipamentDto.prototype, "section", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Id do usuário que está criando o equipamento', type: user_entity_1.User, required: false, example: 1 }),
    __metadata("design:type", user_entity_1.User)
], CreateEquipamentDto.prototype, "user", void 0);
class CreateEquipamentFirstConnectionDto {
    internal_id;
    mac_address;
    equipament_name;
    section;
    sinc_code;
    model;
}
exports.CreateEquipamentFirstConnectionDto = CreateEquipamentFirstConnectionDto;
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Identificação interna do cliente', required: false }),
    (0, class_validator_1.IsString)({ message: "A identificação interna deve ser uma string" }),
    __metadata("design:type", String)
], CreateEquipamentFirstConnectionDto.prototype, "internal_id", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'MAC do equipamento', required: true, example: '44:33:D4:F5' }),
    (0, class_validator_1.IsNotEmpty)({ message: "O MAC do equipamento é obrigatório" }),
    (0, class_validator_1.IsString)({ message: "O MAC do equipamento deve ser uma string" }),
    __metadata("design:type", String)
], CreateEquipamentFirstConnectionDto.prototype, "mac_address", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Nome do equipamento', required: true, example: "Porta de Testes v5" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O nome do equipamento é obrigatório" }),
    (0, class_validator_1.IsString)({ message: "O nome do equipamento deve ser uma string válida" }),
    __metadata("design:type", String)
], CreateEquipamentFirstConnectionDto.prototype, "equipament_name", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Setor em que o equipamento está', required: true, example: "Casa de Máquinas" }),
    (0, class_validator_1.IsNotEmpty)({ message: "O nome do setor é obrigatório" }),
    (0, class_validator_1.IsString)({ message: "O nome do setor deve ser uma string válida" }),
    __metadata("design:type", String)
], CreateEquipamentFirstConnectionDto.prototype, "section", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: 'O Código de Sincronização do usuário é obrigatório' }),
    (0, class_validator_1.IsString)({ message: 'O código de Sincronização do usuário deve ser do tipo string' }),
    __metadata("design:type", String)
], CreateEquipamentFirstConnectionDto.prototype, "sinc_code", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Modelo do equipamento', type: model_entity_1.Model, required: true, example: 1 }),
    (0, class_validator_1.IsNotEmpty)({ message: "O modelo do equipamento é obrigatório" }),
    (0, class_validator_1.IsNumber)({}, { message: "O modelo do equipamento deve ser um número" }),
    __metadata("design:type", model_entity_1.Model)
], CreateEquipamentFirstConnectionDto.prototype, "model", void 0);
//# sourceMappingURL=create-equipament.dto.js.map