"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassesService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const class_entity_1 = require("./entities/class.entity");
const typeorm_2 = require("typeorm");
const client_s3_1 = require("@aws-sdk/client-s3");
let ClassesService = class ClassesService {
    classesRepository;
    constructor(classesRepository) {
        this.classesRepository = classesRepository;
    }
    s3 = new client_s3_1.S3Client({
        region: process.env.AWS_S3_REGION,
        credentials: {
            accessKeyId: process.env.AWS_ACCESS_KEY_ID,
            secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
        },
    });
    async create(createClassDto) {
        if (!createClassDto || createClassDto.length === 0) {
            throw new common_2.BadRequestException('Nenhuma classe foi enviada');
        }
        const titles = createClassDto.map((c) => c.title);
        const existingVideos = await this.classesRepository.find({
            where: { title: (0, typeorm_2.In)(titles) },
        });
        if (existingVideos.length > 0) {
            const existingTitles = existingVideos.map((v) => v.title).join(', ');
            throw new common_2.ConflictException(`Já existe(m) vídeo(s) com o(s) título(s): ${existingTitles}`);
        }
        const newClasses = this.classesRepository.create(createClassDto);
        return await this.classesRepository.save(newClasses);
    }
    findAll() {
        return this.classesRepository.find();
    }
    findAllForManagement() {
        return this.classesRepository.find();
    }
    async findOneForManagement() {
        return this.classesRepository.find();
    }
    async findOne(videoId) {
        if (isNaN(videoId)) {
            throw new common_2.BadRequestException('ID inválido');
        }
        const video = await this.classesRepository.findOneBy({ id: videoId });
        if (!video) {
            throw new common_2.NotFoundException("Ops. Vídeo não encontrado");
        }
        return video;
    }
    async uploadImageToS3(file, fileName) {
        const bucketName = process.env.AWS_S3_BUCKET;
        const uploadParams = new client_s3_1.PutObjectCommand({
            Bucket: bucketName,
            Key: fileName,
            Body: file.buffer,
            ContentType: file.mimetype,
        });
        console.log(uploadParams);
        try {
            await this.s3.send(uploadParams);
            return `https://${bucketName}.s3.${process.env.AWS_S3_REGION}.amazonaws.com/${fileName}`;
        }
        catch (err) {
            throw new common_2.BadRequestException('Erro ao enviar arquivo para o S3: ' + err);
        }
    }
    async update(updateClassDto) {
        const dadosConvertidos = JSON.parse(updateClassDto['data']);
        const dadosParaAtualizar = dadosConvertidos[0];
        const id = dadosParaAtualizar.id;
        const video = await this.findOne(id);
        if (!video) {
            throw new common_2.BadRequestException("Vídeo não encontrado.");
        }
        const videoUpdated = this.classesRepository.merge(video, dadosParaAtualizar);
        try {
            await this.classesRepository.save(videoUpdated);
        }
        catch (error) {
            throw new common_2.BadRequestException(`Erro ao atualizar: ${error.message}`);
        }
        return { success: true, message: "Vídeo atualizado com sucesso", statusCode: 200 };
    }
    async remove(videoId) {
        if (isNaN(videoId)) {
            throw new common_2.BadRequestException('ID inválido');
        }
        const video = await this.classesRepository.findOne({ where: { id: videoId } });
        if (!video) {
            throw new common_2.NotFoundException("Ops. Vídeo não encontrado");
        }
        try {
            await this.classesRepository.remove(video);
        }
        catch (error) {
            console.log(error);
            throw new common_2.BadRequestException("Erro ao tentar remover o vídeo. Erro", error);
        }
        return { message: "Vídeo removido com sucesso" };
    }
    async findClassById(classId) {
        const video = await this.classesRepository.findOneBy({ id: classId });
        if (!video) {
            throw new common_2.NotFoundException("Vídeo não encontrado");
        }
        return video;
    }
};
exports.ClassesService = ClassesService;
exports.ClassesService = ClassesService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(class_entity_1.Class)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ClassesService);
//# sourceMappingURL=classes.service.js.map