"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignaturesService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const signature_entity_1 = require("./entities/signature.entity");
const typeorm_2 = require("typeorm");
const client_s3_1 = require("@aws-sdk/client-s3");
let SignaturesService = class SignaturesService {
    signatureRepository;
    constructor(signatureRepository) {
        this.signatureRepository = signatureRepository;
    }
    s3 = new client_s3_1.S3Client({
        region: process.env.AWS_S3_REGION,
        credentials: {
            accessKeyId: process.env.AWS_ACCESS_KEY_ID,
            secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
        },
    });
    async create(createSignatureDto) {
        const signature = await this.signatureRepository.findOne({
            where: {
                signature: createSignatureDto.signature
            }
        });
        if (signature) {
            throw new common_2.ConflictException("Ops. Já existe uma assinatura com esse código");
        }
        return await this.signatureRepository.save(this.signatureRepository.create(createSignatureDto));
    }
    findAll() {
        return this.signatureRepository.find();
    }
    findAllForManagement() {
        return this.signatureRepository.find();
    }
    async findOneForManagement() {
        return this.signatureRepository.find();
    }
    async findOne(signatureId) {
        const signature = await this.signatureRepository.findOneBy({ id: signatureId });
        if (!signature) {
            throw new common_2.NotFoundException("Ops. Assinatura não encontrada");
        }
        return signature;
    }
    async uploadImageToS3(file, fileName) {
        const bucketName = process.env.AWS_S3_BUCKET;
        const uploadParams = new client_s3_1.PutObjectCommand({
            Bucket: bucketName,
            Key: fileName,
            Body: file.buffer,
            ContentType: file.mimetype,
        });
        console.log(uploadParams);
        try {
            await this.s3.send(uploadParams);
            return `https://${bucketName}.s3.${process.env.AWS_S3_REGION}.amazonaws.com/${fileName}`;
        }
        catch (err) {
            throw new common_2.BadRequestException('Erro ao enviar arquivo para o S3: ' + err);
        }
    }
    async update(signatureId, updateSignatureDto) {
        const signature = await this.findOne(signatureId);
        const signatureUpdated = this.signatureRepository.merge(signature, updateSignatureDto);
        try {
            await this.signatureRepository.save(signatureUpdated);
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar atualizar um ou mais dados da assinatura. Error: ", error);
        }
        return { success: true, message: "Assinatura atualizada com sucesso", statusCode: 200 };
    }
    async remove(signatureId) {
        const signature = await this.findOne(signatureId);
        try {
            await this.signatureRepository.softDelete(signature.id);
        }
        catch (error) {
            throw new common_2.BadRequestException("Erro ao tentar remover a assinatura. Erro", error);
        }
        return { message: "Assinatura removida com sucesso" };
    }
    async findSignatureById(signatureId) {
        const signature = await this.signatureRepository.findOneBy({ id: signatureId });
        if (!signature) {
            throw new common_2.NotFoundException("Assinatura não encontrada");
        }
        return signature;
    }
};
exports.SignaturesService = SignaturesService;
exports.SignaturesService = SignaturesService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(signature_entity_1.Signature)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], SignaturesService);
//# sourceMappingURL=signatures.service.js.map