import { CreateSignatureDto } from './dto/create-signature.dto';
import { Signature } from './entities/signature.entity';
import { Repository } from 'typeorm';
import { UpdateSignatureDto } from './dto/update-signature.dto';
export declare class SignaturesService {
    private signatureRepository;
    constructor(signatureRepository: Repository<Signature>);
    private s3;
    create(createSignatureDto: CreateSignatureDto): Promise<Signature>;
    findAll(): Promise<Signature[]>;
    findAllForManagement(): Promise<Signature[]>;
    findOneForManagement(): Promise<Signature[]>;
    findOne(signatureId: number): Promise<Signature>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
    update(signatureId: number, updateSignatureDto: UpdateSignatureDto): Promise<{
        success: boolean;
        message: string;
        statusCode: number;
    }>;
    remove(signatureId: number): Promise<{
        message: string;
    }>;
    findSignatureById(signatureId: number): Promise<Signature>;
}
