import { AddItemFromCartDto } from './dto/add-item-from-cart-.dto';
import { RemoveItemFromCartDto, UpdateShoppingCartDto } from './dto/update-shopping_cart.dto';
import { Order } from '../orders/entities/order.entity';
import { Repository } from 'typeorm';
import { Status } from 'src/shared/enums/enum';
import { UsersService } from 'src/shared/users/users.service';
import { OrderTransactions } from '../orders/entities/order_transaction.entity';
import { ProductsService } from '../products/products.service';
import { OrderProduct } from '../orders/entities/order_product.entity';
import { Cupom } from '../cupom/entities/cupom.entity';
export declare class ShoppingCartService {
    private readonly shoppingCartRepository;
    private readonly orderTransactionRepository;
    private readonly orderProductRepository;
    private readonly cupomRepository;
    private readonly usersService;
    private readonly productsService;
    constructor(shoppingCartRepository: Repository<Order>, orderTransactionRepository: Repository<OrderTransactions>, orderProductRepository: Repository<OrderProduct>, cupomRepository: Repository<Cupom>, usersService: UsersService, productsService: ProductsService);
    addItemFromCart(currentUser: any, addItemFromCartDto: AddItemFromCartDto): Promise<{
        message: string;
    }>;
    getCartContents(currentUser: any): Promise<{
        message: string;
        order?: undefined;
    } | {
        order: {
            id: number;
            status: Status;
            total_items: number;
            cupom: Cupom;
            subtotal: number;
            total_amount: number;
            discount_applied: number;
            items: {
                id: number;
                name: string;
                description: string;
                image: string;
                quantity: number;
                price: number;
                quantity_in_stock: number;
            }[];
        };
        message?: undefined;
    }>;
    countTotalItemsInOpenOrder(currentUser: any): Promise<{
        total_quantity: any;
    }>;
    updateItemQuantityInCart(currentUser: any, updateShoppingCartDto: UpdateShoppingCartDto): Promise<{
        message: string;
    }>;
    removeItemFromCart(currentUser: any, removeItemFromCartDto: RemoveItemFromCartDto): Promise<{
        message: string;
    }>;
    getOrCreateShoppingCart(userId: number): Promise<Order>;
    findOpenOrderByUser(userId: number): Promise<Order | null>;
    private _recalculateCartTotalsAndUpdateStoreId;
}
