"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersModule = void 0;
const common_2 = require("@nestjs/common");
const orders_service_1 = require("./orders.service");
const orders_controller_1 = require("./orders.controller");
const typeorm_1 = require("@nestjs/typeorm");
const order_entity_1 = require("./entities/order.entity");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const jwt_1 = require("@nestjs/jwt");
const order_product_entity_1 = require("./entities/order_product.entity");
const asaas_module_1 = require("../asaas/asaas.module");
const users_module_1 = require("../../shared/users/users.module");
const order_transaction_entity_1 = require("./entities/order_transaction.entity");
const product_entity_1 = require("../products/entities/product.entity");
const creditcard_entity_1 = require("../creditcard/entities/creditcard.entity");
let OrdersModule = class OrdersModule {
};
exports.OrdersModule = OrdersModule;
exports.OrdersModule = OrdersModule = __decorate([
    (0, common_2.Module)({
        imports: [(0, common_2.forwardRef)(() => asaas_module_1.AsaasModule), users_module_1.UsersModule,
            typeorm_1.TypeOrmModule.forFeature([order_entity_1.Order, user_entity_1.User, order_product_entity_1.OrderProduct, order_transaction_entity_1.OrderTransactions, product_entity_1.Product, creditcard_entity_1.Creditcard]),
            jwt_1.JwtModule.register({
                secret: process.env.JWT_SECRET || 'secret'
            })
        ],
        controllers: [orders_controller_1.OrdersController],
        providers: [orders_service_1.OrdersService],
        exports: [orders_service_1.OrdersService]
    })
], OrdersModule);
//# sourceMappingURL=orders.module.js.map