"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Course_paymentService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const course_payment_entity_1 = require("./entities/course_payment.entity");
const asaas_service_1 = require("../asaas/asaas.service");
const users_service_1 = require("../../shared/users/users.service");
const courses_service_1 = require("../courses/courses.service");
const creditcard_entity_1 = require("../creditcard/entities/creditcard.entity");
let Course_paymentService = class Course_paymentService {
    course_paymentRepository;
    creditcardRepository;
    asaasService;
    usersService;
    courseService;
    constructor(course_paymentRepository, creditcardRepository, asaasService, usersService, courseService) {
        this.course_paymentRepository = course_paymentRepository;
        this.creditcardRepository = creditcardRepository;
        this.asaasService = asaasService;
        this.usersService = usersService;
        this.courseService = courseService;
    }
    async create(currentUserId, id, createChargeDto) {
        const user = await this.usersService.findUserById(currentUserId);
        const course = await this.courseService.findCourseById(id);
        if (course.price == 0) {
            const courseFree = await this.course_paymentRepository.create({
                user: { id: user.id },
                course: { id: course.id },
                amount: course.price,
                status: 'PAID'
            });
            const savedPayment = await this.course_paymentRepository.save(courseFree);
            return { success: true, message: `Curso adquirido com sucesso`, code: 200 };
        }
        const course_payment = this.course_paymentRepository.create({
            user: { id: user.id },
            course: { id: course.id },
            amount: course.price,
            status: 'PENDING'
        });
        const savedPayment = await this.course_paymentRepository.save(course_payment);
        if (createChargeDto.paymentMethod == 'CREDIT_CARD') {
            const existCard = await this.creditcardRepository.findOne({
                where: { user: { id: currentUserId },
                    credit_card_number: createChargeDto.numeroCartao },
            });
            if (!existCard) {
                throw new Error("Cartão de crédito não encontrado");
            }
            const assasPayment = await this.asaasService.createCreditCardPaymentCourse({ user: user, value: course.price, orderId: savedPayment.id, creditCard: existCard });
            savedPayment.asaasPaymentId = assasPayment.paymentId;
            await this.course_paymentRepository.save(savedPayment);
            return assasPayment;
        }
        const assasPayment = await this.asaasService.createPixChargeForCourse({ user: user, value: course.price, orderId: savedPayment.id });
        savedPayment.asaasPaymentId = assasPayment.paymentId;
        await this.course_paymentRepository.save(savedPayment);
        return assasPayment;
    }
    async getQrCode(currentUserId) {
        const userPayment = await this.course_paymentRepository.findOne({
            where: {
                user: { id: currentUserId },
                status: 'PENDING'
            },
            order: { created_at: 'DESC' }
        });
        if (!userPayment)
            return { message: "Nenhum pagamento pendente encontrado." };
        return await this.asaasService.getPixQrCode(userPayment.asaasPaymentId);
    }
    async confirmPayment(paymentId) {
        const payment = await this.course_paymentRepository.findOne({
            where: { asaasPaymentId: paymentId,
                status: 'PAID'
            },
        });
        if (payment) {
            return { pago: true };
        }
        return { pago: false };
    }
};
exports.Course_paymentService = Course_paymentService;
exports.Course_paymentService = Course_paymentService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(course_payment_entity_1.Course_payment)),
    __param(1, (0, typeorm_1.InjectRepository)(creditcard_entity_1.Creditcard)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        asaas_service_1.AsaasService,
        users_service_1.UsersService,
        courses_service_1.CourseService])
], Course_paymentService);
//# sourceMappingURL=course_payment.service.js.map