import { Repository } from 'typeorm';
import { Course_payment } from "./entities/course_payment.entity";
import { CreateCourse_paymentDto } from './dto/create-course_payment.dto';
import { AsaasService } from '../asaas/asaas.service';
import { UsersService } from 'src/shared/users/users.service';
import { CourseService } from '../courses/courses.service';
import { Creditcard } from '../creditcard/entities/creditcard.entity';
export declare class Course_paymentService {
    private course_paymentRepository;
    private creditcardRepository;
    private readonly asaasService;
    private readonly usersService;
    private readonly courseService;
    constructor(course_paymentRepository: Repository<Course_payment>, creditcardRepository: Repository<Creditcard>, asaasService: AsaasService, usersService: UsersService, courseService: CourseService);
    create(currentUserId: number, id: number, createChargeDto: CreateCourse_paymentDto): Promise<{
        paymentId: any;
    } | {
        success: boolean;
        message: string;
        code: number;
    }>;
    getQrCode(currentUserId: number): Promise<any>;
    confirmPayment(paymentId: string): Promise<{
        pago: boolean;
    }>;
}
