"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_2 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const users_module_1 = require("./shared/users/users.module");
const typeorm_1 = require("@nestjs/typeorm");
const ormconfig_1 = require("../ormconfig");
const doors_module_1 = require("./visoflex360/doors/doors.module");
const equipaments_module_1 = require("./visoflex360/equipaments/equipaments.module");
const files_module_1 = require("./visoflex360/files/files.module");
const industrial_fans_module_1 = require("./visoflex360/industrial_fans/industrial_fans.module");
const models_module_1 = require("./visoflex360/models/models.module");
const category_module_1 = require("./shared/category/category.module");
const contacts_module_1 = require("./visoflex360/contacts/contacts.module");
const auth_module_1 = require("./shared/auth/auth.module");
const config_1 = require("@nestjs/config");
const event_emitter_1 = require("@nestjs/event-emitter");
const watchers_module_1 = require("./visoflex360/watchers/watchers.module");
const products_module_1 = require("./ecommerce/products/products.module");
const asaas_module_1 = require("./ecommerce/asaas/asaas.module");
const orders_module_1 = require("./ecommerce/orders/orders.module");
const shopping_cart_module_1 = require("./ecommerce/shopping_cart/shopping_cart.module");
const group_module_1 = require("./visoflex360/group/group.module");
const messaging_module_1 = require("./shared/messaging/messaging.module");
const signatures_module_1 = require("./ecommerce/signatures/signatures.module");
const reports_module_1 = require("./ecommerce/reports/reports.module");
const classes_module_1 = require("./ecommerce/videos/classes.module");
const courses_module_1 = require("./ecommerce/courses/courses.module");
const subscription_plan_module_1 = require("./visoflex360/subscription_plan/subscription_plan.module");
const course_payment_module_1 = require("./ecommerce/course_payment/course_payment.module");
const mailer_1 = require("@nestjs-modules/mailer");
const handlebars_adapter_1 = require("@nestjs-modules/mailer/dist/adapters/handlebars.adapter");
const path_1 = require("path");
const frete_info_module_1 = require("./ecommerce/frete_info/frete_info.module");
const cupom_module_1 = require("./ecommerce/cupom/cupom.module");
const dashboard_module_1 = require("./ecommerce/dashboard/dashboard.module");
const creditcard_module_1 = require("./ecommerce/creditcard/creditcard.module");
const post_module_1 = require("./visoflex360/post/post.module");
const agenda_module_1 = require("./visoflex360/agenda/agenda.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_2.Module)({
        imports: [
            mailer_1.MailerModule.forRoot({
                transport: {
                    host: process.env.MAIL_HOST,
                    port: Number(process.env.MAIL_PORT),
                    secure: false,
                    auth: {
                        user: process.env.MAIL_USER,
                        pass: process.env.MAIL_PASS,
                    },
                },
                defaults: {
                    from: `"No Reply" <${process.env.MAIL_FROM}>`,
                },
                template: {
                    dir: (0, path_1.join)(process.cwd(), '/templates'),
                    adapter: new handlebars_adapter_1.HandlebarsAdapter(),
                    options: {
                        strict: true,
                    },
                },
            }),
            event_emitter_1.EventEmitterModule.forRoot(),
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            typeorm_1.TypeOrmModule.forRootAsync({
                useFactory: async () => ({
                    ...ormconfig_1.config,
                    async onDataSourceInit(dataSource) {
                        await dataSource.query('PRAGMA foreign_keys = ON');
                    },
                }),
            }),
            typeorm_1.TypeOrmModule.forRoot(ormconfig_1.config),
            users_module_1.UsersModule,
            doors_module_1.DoorsModule,
            equipaments_module_1.EquipamentsModule,
            files_module_1.FilesModule,
            industrial_fans_module_1.IndustrialFansModule,
            classes_module_1.ClassModule,
            models_module_1.ModelsModule,
            category_module_1.CategoryModule,
            contacts_module_1.ContactsModule,
            auth_module_1.AuthModule,
            watchers_module_1.WatchersModule,
            orders_module_1.OrdersModule,
            products_module_1.ProductsModule,
            asaas_module_1.AsaasModule,
            shopping_cart_module_1.ShoppingCartModule,
            group_module_1.GroupModule,
            messaging_module_1.MessagingModule,
            reports_module_1.ReportsModule,
            signatures_module_1.SignaturesModule,
            courses_module_1.CourseModule,
            subscription_plan_module_1.SubscriptionPlanModule,
            course_payment_module_1.Course_paymentModule,
            frete_info_module_1.FreteInfoModule,
            cupom_module_1.CupomModule,
            dashboard_module_1.DashboardModule,
            creditcard_module_1.CreditcardModule,
            post_module_1.PostModule,
            agenda_module_1.AgendaModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map