"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const post_entity_1 = require("./entities/post.entity");
const typeorm_2 = require("typeorm");
const client_s3_1 = require("@aws-sdk/client-s3");
const comentario_entity_1 = require("./entities/comentario.entity");
const postInteration_entity_1 = require("./entities/postInteration.entity");
const enum_1 = require("../../shared/enums/enum");
const courses_service_1 = require("../../ecommerce/courses/courses.service");
const agenda_service_1 = require("../agenda/agenda.service");
let PostService = class PostService {
    postRepository;
    comentarioRepository;
    postInterationRepository;
    courseService;
    agendaService;
    constructor(postRepository, comentarioRepository, postInterationRepository, courseService, agendaService) {
        this.postRepository = postRepository;
        this.comentarioRepository = comentarioRepository;
        this.postInterationRepository = postInterationRepository;
        this.courseService = courseService;
        this.agendaService = agendaService;
    }
    s3 = new client_s3_1.S3Client({
        region: process.env.AWS_S3_REGION,
        credentials: {
            accessKeyId: process.env.AWS_ACCESS_KEY_ID,
            secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
        },
    });
    async create(createPostDto, currentUser, imagem) {
        let imageUrl;
        if (imagem) {
            const fileName = `posts/${Date.now()}-${imagem.originalname}`;
            imageUrl = await this.uploadImageToS3(imagem, fileName);
        }
        const post = this.postRepository.create({
            titulo: createPostDto.titulo,
            subtitulo: createPostDto.subtitulo,
            corpo: createPostDto.corpo,
            data: new Date(),
            url: imageUrl,
            user: {
                id: currentUser.id,
            },
            categoria: createPostDto.categoria,
        });
        return await this.postRepository.save(post);
    }
    async findAll(currentUser) {
        const all = await this.postRepository
            .createQueryBuilder('post')
            .leftJoinAndSelect('post.user', 'user')
            .loadRelationCountAndMap('post.totalComentarios', 'post.comentario', 'comentario', (qb) => qb
            .where('comentario.corpo IS NOT NULL')
            .andWhere('comentario.corpo <> :empty', { empty: '' }))
            .loadRelationCountAndMap('post.totalViews', 'post.postInteration', 'postInterationView', (qb) => qb.where('postInterationView.viewPost = :view', { view: true }))
            .loadRelationCountAndMap('post.totalLikes', 'post.postInteration', 'postInterationLike', (qb) => qb.where('postInterationLike.likePost = :like', { like: true }))
            .loadRelationCountAndMap('post.totalDeslikes', 'post.postInteration', 'postInterationDeslike', (qb) => qb.where('postInterationDeslike.deslikePost = :deslike', {
            deslike: true,
        }))
            .select([
            'post.id',
            'post.titulo',
            'post.subtitulo',
            'post.corpo',
            'post.categoria',
            'post.data',
            'post.url',
            'user.user_name',
            'user.email',
        ])
            .getMany();
        if (currentUser.roles === enum_1.Roles.USER) {
            const courses = await this.courseService.findAllByUser(currentUser.id);
            const courseIds = courses.map((course) => course.id);
            const courseProgressList = await Promise.all(courseIds.map((courseId) => this.courseService.courseProgress(currentUser.id, courseId)));
            const agendamentos = await this.agendaService.findAll();
            return {
                posts: all,
                course: courses,
                courseProgress: courseProgressList,
                agendamentos: agendamentos,
            };
        }
        return all;
    }
    async findOne(id, currentUser) {
        const existPost = await this.postRepository.findOne({
            where: { id },
        });
        if (!existPost) {
            throw new common_2.BadRequestException('Post não existe!');
        }
        const isview = await this.postInterationRepository.findOne({
            where: { post: { id }, user: { id: currentUser.id } },
        });
        if (isview === null) {
            const create = await this.postInterationRepository.create({
                user: { id: currentUser.id },
                viewPost: true,
                post: { id: id },
            });
            await this.postInterationRepository.save(create);
        }
        if (isview?.viewPost === false) {
            await this.postInterationRepository.update({ user: { id } }, { viewPost: true });
        }
        const post = await this.postRepository
            .createQueryBuilder('post')
            .innerJoinAndSelect('post.user', 'user')
            .loadRelationCountAndMap('post.totalLikes', 'post.postInteration', 'postInteration', (qb) => qb.where('postInteration.likePost = :like', { like: true }))
            .loadRelationCountAndMap('post.totalDeslikes', 'post.postInteration', 'postInteration', (qb) => qb.where('postInteration.deslikePost = :deslike', { deslike: true }))
            .loadRelationCountAndMap('post.view', 'post.postInteration', 'postInteration', (qb) => qb.where('postInteration.viewPost = :view', { view: true }))
            .select([
            'post.id',
            'post.titulo',
            'post.subtitulo',
            'post.corpo',
            'post.data',
            'post.like',
            'post.url',
            'user.id',
            'user.user_name',
            'user.email',
        ])
            .where('post.id = :id', { id })
            .getOne();
        if (!post)
            return null;
        const comentarios = await this.comentarioRepository
            .createQueryBuilder('comentario')
            .innerJoinAndSelect('comentario.user', 'user')
            .innerJoin('comentario.post', 'post')
            .select([
            'comentario.corpo',
            'comentario.data',
            'comentario.like',
            'comentario.id',
            'comentario.respostaId',
            'user.id',
            'user.user_name',
            'user.email',
        ])
            .where('post.id = :id', { id })
            .andWhere('comentario.corpo IS NOT NULL')
            .andWhere('comentario.corpo <> :empty', { empty: '' })
            .getRawMany();
        const interacaoPost = await this.postInterationRepository
            .createQueryBuilder('postinteration')
            .innerJoin('postinteration.post', 'post')
            .innerJoin('postinteration.user', 'user')
            .select([
            'postinteration.viewPost AS viewPost',
            'postinteration.likePost AS likePost',
            'postinteration.deslikePost AS deslikePost',
        ])
            .where('post.id = :postId', { postId: id })
            .andWhere('user.id =  :userId', { userId: currentUser.id })
            .getRawMany();
        const resultado = {
            ...post,
            comentarios,
            interacaoPost,
        };
        return resultado;
    }
    async getComentarios(postId) {
        return await this.comentarioRepository
            .createQueryBuilder('comentario')
            .innerJoin('comentario.user', 'user')
            .where('comentario.postId = :postId', { postId })
            .select(['comentario', 'user.user_name', 'user.email'])
            .getMany();
    }
    async like(id, currentUser) {
        const existPost = await this.postRepository.findOne({
            where: { id },
        });
        if (!existPost) {
            throw new common_2.BadRequestException('Post não existe!');
        }
        const isdeslike = await this.postInterationRepository.findOne({
            where: {
                post: { id: id },
                user: { id: currentUser.id },
                deslikePost: true,
            },
        });
        if (isdeslike) {
            await this.postInterationRepository.update({ user: { id: currentUser.id }, post: { id: id } }, {
                likePost: true,
                deslikePost: false,
            });
        }
        await this.postInterationRepository.update({ user: { id: currentUser.id }, post: { id: id } }, {
            likePost: true,
        });
        return 'like adicionado!';
    }
    async deslike(id, currentUser) {
        const existPost = await this.postRepository.findOne({
            where: { id },
        });
        if (!existPost) {
            throw new common_2.BadRequestException('Post não existe!');
        }
        const islike = await this.postInterationRepository.findOne({
            where: {
                post: { id: id },
                user: { id: currentUser.id },
                likePost: true,
            },
        });
        if (islike) {
            await this.postInterationRepository.update({ user: { id: currentUser.id }, post: { id: id } }, {
                deslikePost: true,
                likePost: false,
            });
        }
        await this.postInterationRepository.update({ user: { id: currentUser.id }, post: { id: id } }, {
            deslikePost: true,
        });
        return 'deslike adicionado!';
    }
    async createComentario(createComentarioDto, currentUser, postId) {
        const newComentario = await this.comentarioRepository.create({
            corpo: createComentarioDto.corpo,
            respostaId: createComentarioDto.respostaId,
            data: new Date(),
            post: { id: postId },
            user: { id: currentUser.id },
        });
        return await this.comentarioRepository.save(newComentario);
    }
    update(id, updatePostDto) {
        return `This action updates a #${id} post`;
    }
    remove(id) {
        return `This action removes a #${id} post`;
    }
    async uploadImageToS3(file, fileName) {
        const bucketName = process.env.AWS_S3_BUCKET;
        const uploadParams = new client_s3_1.PutObjectCommand({
            Bucket: bucketName,
            Key: fileName,
            Body: file.buffer,
            ContentType: file.mimetype,
        });
        try {
            await this.s3.send(uploadParams);
            return `https://${bucketName}.s3.${process.env.AWS_S3_REGION}.amazonaws.com/${fileName}`;
        }
        catch (err) {
            throw new common_2.BadRequestException('Erro ao enviar arquivo para o S3: ' + err);
        }
    }
};
exports.PostService = PostService;
exports.PostService = PostService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(post_entity_1.Post)),
    __param(1, (0, typeorm_1.InjectRepository)(comentario_entity_1.Comentario)),
    __param(2, (0, typeorm_1.InjectRepository)(postInteration_entity_1.PostInteration)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        courses_service_1.CourseService,
        agenda_service_1.AgendaService])
], PostService);
//# sourceMappingURL=post.service.js.map