"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostController = void 0;
const common_2 = require("@nestjs/common");
const post_service_1 = require("./post.service");
const update_post_dto_1 = require("./dto/update-post.dto");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const create_comentario_dto_1 = require("./dto/create-comentario.dto");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const enum_1 = require("../../shared/enums/enum");
const role_guard_1 = require("../../shared/auth/role/role.guard");
let PostController = class PostController {
    postService;
    constructor(postService) {
        this.postService = postService;
    }
    create(data, imagemUrl, currentUser) {
        const createPostDto = JSON.parse(data);
        return this.postService.create(createPostDto, currentUser, imagemUrl);
    }
    createComentario(createComentarioDto, currentUser, postId) {
        return this.postService.createComentario(createComentarioDto, currentUser, +postId);
    }
    findAll(currentUser) {
        return this.postService.findAll(currentUser);
    }
    getComentarios(id) {
        return this.postService.getComentarios(+id);
    }
    findOne(id, currentUser) {
        return this.postService.findOne(+id, currentUser);
    }
    like(id, currentUser) {
        return this.postService.like(+id, currentUser);
    }
    deslike(id, currentUser) {
        return this.postService.deslike(+id, currentUser);
    }
    update(id, updatePostDto) {
        return this.postService.update(+id, updatePostDto);
    }
    remove(id) {
        return this.postService.remove(+id);
    }
};
exports.PostController = PostController;
__decorate([
    (0, common_2.Post)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('imagem', {
        storage: (0, multer_1.memoryStorage)(),
        fileFilter: (req, file, cb) => {
            if (!file.mimetype.match(/\/(jpg|jpeg|png)$/)) {
                return cb(new Error('Apenas imagens JPG, JPEG ou PNG'), false);
            }
            cb(null, true);
        },
    })),
    __param(0, (0, common_2.Body)('data')),
    __param(1, (0, common_2.UploadedFile)()),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, user_entity_1.User]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "create", null);
__decorate([
    (0, common_2.Post)(':postId/comentario'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __param(2, (0, common_2.Param)('postId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_comentario_dto_1.CreateComentarioDto,
        user_entity_1.User, String]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "createComentario", null);
__decorate([
    (0, common_2.Get)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.USER),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)(':id/comentarios'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "getComentarios", null);
__decorate([
    (0, common_2.Get)(':id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "findOne", null);
__decorate([
    (0, common_2.Patch)(':id/like'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "like", null);
__decorate([
    (0, common_2.Patch)(':id/deslike'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "deslike", null);
__decorate([
    (0, common_2.Patch)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_post_dto_1.UpdatePostDto]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PostController.prototype, "remove", null);
exports.PostController = PostController = __decorate([
    (0, common_2.Controller)('post'),
    __metadata("design:paramtypes", [post_service_1.PostService])
], PostController);
//# sourceMappingURL=post.controller.js.map