"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilesService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const files_entity_1 = require("./entities/files.entity");
const typeorm_2 = require("typeorm");
const promises_1 = require("fs/promises");
const path_1 = require("path");
const path_entity_1 = require("./entities/path.entity");
let FilesService = class FilesService {
    filesRepository;
    folderRepository;
    constructor(filesRepository, folderRepository) {
        this.filesRepository = filesRepository;
        this.folderRepository = folderRepository;
    }
    async create(file, createFilesDto) {
        const folderEntity = await this.folderRepository.findOne({
            where: { id: Number(createFilesDto.folder) },
        });
        if (!folderEntity) {
            throw new common_2.NotFoundException('A pasta informada não existe.');
        }
        const newFile = this.filesRepository.create({
            file_name: file.originalname,
            name: createFilesDto.file_name,
            version: createFilesDto.version,
            description: createFilesDto.description,
            path: file.path,
            type: file.mimetype,
            size: file.size,
            folder: folderEntity,
        });
        await this.filesRepository.save(newFile);
        return 'Arquivo salvo com sucesso!';
    }
    async createFolder(createFolderDto) {
        console.log('SERVICE CHAMADA!', createFolderDto);
        const { name, path } = createFolderDto;
        const allowedRoles = [
            ...new Set([
                'admin',
                'admin-ecommerce',
                'admin-cursos',
                'admin-monitoramento',
                ...(createFolderDto.allowedRoles || []),
            ]),
        ];
        const sanitizePath = (p) => {
            if (!p)
                return '/';
            return `/${p
                .split('/')
                .filter((x) => x)
                .join('/')}`;
        };
        if (!path || path.trim() === '' || path === '/') {
            const exists = await this.folderRepository.findOne({
                where: { name, parent: (0, typeorm_2.IsNull)() },
            });
            if (exists)
                return exists;
            const newFolder = this.folderRepository.create({
                name,
                path: `/`,
                allowedRoles,
                parent: undefined,
            });
            return await this.folderRepository.save(newFolder);
        }
        const parts = path.split('/').filter((p) => p.trim() !== '');
        let parent = null;
        let currentPath = '';
        for (const part of parts) {
            currentPath = `${currentPath}/${part}`;
            let folder = await this.folderRepository.findOne({
                where: {
                    name: part,
                    parent: parent ? { id: parent.id } : (0, typeorm_2.IsNull)(),
                },
            });
            if (!folder) {
                folder = this.folderRepository.create({
                    name: part,
                    path: currentPath,
                    allowedRoles,
                    parent: parent || undefined,
                });
                folder = await this.folderRepository.save(folder);
            }
            parent = folder;
        }
        const parentPathStr = parent?.path === '/' ? '' : parent?.path || '';
        const finalPath = `${parentPathStr}/${name}`;
        const existsFinal = await this.folderRepository.findOne({
            where: {
                name,
                parent: parent ? { id: parent.id } : (0, typeorm_2.IsNull)(),
            },
        });
        if (existsFinal)
            return existsFinal;
        const finalFolder = this.folderRepository.create({
            name,
            path: finalPath,
            allowedRoles,
            parent: parent || undefined,
        });
        return await this.folderRepository.save(finalFolder);
    }
    async getRaiz(currentUser) {
        return this.folderRepository.find({
            where: {
                parent: (0, typeorm_2.IsNull)(),
                allowedRoles: (0, typeorm_2.Like)(`%${currentUser.roles}%`),
            },
        });
    }
    async getRelation(pastaRaizId, currentUser) {
        const parentFolder = await this.folderRepository.findOne({
            where: { id: pastaRaizId, allowedRoles: (0, typeorm_2.Like)(`%${currentUser.roles}%`) },
            relations: ['children', 'files'],
        });
        if (!parentFolder) {
            throw new common_2.NotFoundException(`Pasta com ID ${pastaRaizId} não encontrada.`);
        }
        const { children, files: originalFiles } = parentFolder;
        const files = originalFiles.map((file) => {
            const { path, ...fileData } = file;
            return { fileData };
        });
        return { children, files };
    }
    async deleteFolder(id) {
        const folder = await this.folderRepository.findOne({
            where: { id },
            relations: ['children'],
        });
        if (!folder) {
            throw new common_2.NotFoundException('Pasta não encontrada.');
        }
        await this.folderRepository.remove(folder);
    }
    async editPath(id, updateFolderDto) {
        const folder = await this.folderRepository.findOne({ where: { id } });
        if (!folder) {
            throw new common_2.NotFoundException(`Não foi possível editar a pasta com ID ${id}`);
        }
        const oldPath = folder.path;
        let newPath = oldPath;
        if (updateFolderDto.name) {
            const parts = oldPath.split('/').filter(Boolean);
            parts[parts.length - 1] = updateFolderDto.name;
            newPath = '/' + parts.join('/');
        }
        await this.folderRepository.update(id, {
            name: updateFolderDto.name ?? folder.name,
            path: newPath,
            allowedRoles: updateFolderDto.allowedRoles
                ? [
                    ...new Set([
                        'admin',
                        'admin-ecommerce',
                        'admin-cursos',
                        'admin-monitoramento',
                        ...updateFolderDto.allowedRoles,
                    ]),
                ]
                : folder.allowedRoles,
        });
        const children = await this.folderRepository.query(`SELECT * FROM folders WHERE path LIKE ? AND id != ?`, [`${oldPath}%`, id]);
        for (const child of children) {
            const updatedPath = child.path.replace(oldPath, newPath);
            await this.folderRepository.update(child.id, { path: updatedPath });
        }
        return { oldPath, newPath };
    }
    async findAll() {
        return this.filesRepository.find({
            select: {
                id: true,
                file_name: true,
                name: true,
                version: true,
                description: true,
                type: true,
                size: true,
                created_on: true,
            },
            order: { created_on: 'DESC' },
        });
    }
    async getFilePath(id) {
        const file = await this.filesRepository.findOne({
            where: { id },
        });
        if (!file) {
            throw new common_2.NotFoundException('Arquivo não encontrado');
        }
        return file.path;
    }
    async remove(id) {
        const files = await this.filesRepository.findOneBy({ id });
        if (!files) {
            throw new common_2.NotFoundException('Arquivo não encontrado');
        }
        const path = (0, path_1.join)(files.path);
        try {
            await (0, promises_1.unlink)(path);
        }
        catch (error) {
            throw new common_2.NotFoundException({ message: 'Arquivo não encontrado no disco...' }, error.message);
        }
        await this.filesRepository.delete(id);
        return true;
    }
};
exports.FilesService = FilesService;
exports.FilesService = FilesService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(files_entity_1.Files)),
    __param(1, (0, typeorm_1.InjectRepository)(path_entity_1.Folder)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], FilesService);
//# sourceMappingURL=files.service.js.map