import { EquipamentsService } from './equipaments.service';
import { UpdateEquipamentDto, UpdateSchedulesByGroupDto, UpdateSchedulesDto, UpdateStatusDto } from './dto/update-equipament.dto';
import { CreateEquipamentFirstConnectionDto } from './dto/create-equipament.dto';
import { AddEquipamentToGroupDto } from './dto/add-equipament-to-group.dto';
export declare class EquipamentsController {
    private readonly equipamentsService;
    constructor(equipamentsService: EquipamentsService);
    createFirstConnection(dto: CreateEquipamentFirstConnectionDto): Promise<any>;
    addEquipamentToGroup(currentUser: any, addEquipamentToGroupDto: AddEquipamentToGroupDto): Promise<{
        message: string;
    }>;
    countAll(): Promise<number>;
    findAll(): Promise<import("./entities/equipament.entity").Equipament[]>;
    ping(mac: string): Promise<{
        message: string;
        more: any;
    }>;
    findSchedulesByEquipament(equipId: string, id: string): Promise<import("./entities/schedules.entity").Schedules>;
    findMonitoredEquipaments(id: string): Promise<any[]>;
    countForCards(): Promise<{
        totalEquipaments: number;
        totalDoors: number;
        totalFans: number;
    }>;
    findAllByUser(id: string): Promise<{
        id: number;
        equipament_name: string;
        internal_id: string;
        section: string;
        created_at: Date;
        latest_maintanence: Date;
        door?: import("../doors/entities/door.entity").Door;
        fan?: import("../industrial_fans/entities/industrial_fan.entity").IndustrialFan;
    }[]>;
    findOne(id: number, type: string): Promise<any>;
    countByType(type: string): Promise<number>;
    updateStatus(dto: UpdateStatusDto): Promise<string>;
    update(equipId: string, id: string, updateEquipamentDto: UpdateEquipamentDto): Promise<{
        message: string;
    }>;
    unlinkDeviceByUser(equipId: string, id: string): Promise<string>;
    updateScheduleByEquipament(equipId: string, id: string, updateSchedulesDto: UpdateSchedulesDto): Promise<{
        message: string;
    }>;
    updateScheduleByGroup(currentUser: any, updateScheduleByGroupDto: UpdateSchedulesByGroupDto): Promise<{
        message: string;
    }>;
    removeEquipamentFromGroup(currentUser: any, removeEquipamentFromGroupDto: AddEquipamentToGroupDto): Promise<{
        message: string;
    }>;
    remove(id: string, equipId: string): Promise<string>;
}
