import { Repository } from 'typeorm';
import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto, UpdateUserPasswordDto } from './dto/update-user.dto';
import { User } from './entities/user.entity';
import { Equipament } from 'src/visoflex360/equipaments/entities/equipament.entity';
import { Door } from 'src/visoflex360/doors/entities/door.entity';
import { AuthService } from 'src/shared/auth/auth.service';
import { PasswordResetToken } from './entities/password-reset-token.entity';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { ResetPasswordDto } from './dto/recover-password.dto';
export declare class UsersService {
    private usersRepository;
    private resetTokenRepository;
    private equipamentsRepository;
    private doorsRepository;
    private readonly authService;
    private readonly eventEmitter;
    constructor(usersRepository: Repository<User>, resetTokenRepository: Repository<PasswordResetToken>, equipamentsRepository: Repository<Equipament>, doorsRepository: Repository<Door>, authService: AuthService, eventEmitter: EventEmitter2);
    create(createUserDto: CreateUserDto): Promise<{
        access_token: string;
    } | {
        message: string[];
    }>;
    forgotPassword(email: string): Promise<{
        message: string;
    }>;
    findMyProfile(id: number): Promise<{
        id: number;
        document: string;
        company_name: string;
        user_name: string;
        email: string;
        roles: import("../enums/enum").Roles;
        cellphone: string;
        maintanance_notf: boolean;
        alert_notf: boolean;
        sinc_code: string;
    }>;
    findOne(id: number): Promise<User | null>;
    findOneByEmail(email: string): Promise<User | null>;
    findResume(): Promise<{
        id: number;
        nome_empresa: string;
        documento: string;
        nome_cliente: string;
        sinc_code: string;
        email: string;
        celular: string;
        total_equipamentos: number;
        alertas_portas: number;
        status: boolean;
        role: import("../enums/enum").Roles;
    }[]>;
    countAll(): Promise<number>;
    resetPassword(resetDto: ResetPasswordDto): Promise<{
        message: string;
    }>;
    changeUserPassword(id: any, updateUserPasswordDto: UpdateUserPasswordDto): Promise<string>;
    updateUserStatus(id: number, aproved: boolean): Promise<string>;
    update(id: number, updateUserDto: UpdateUserDto): Promise<string>;
    remove(id: number): Promise<{
        message: string;
    }>;
    findUserById(userId: number): Promise<User>;
    findUserWithoutRestricData(id: any): Promise<User>;
}
