"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MessagingService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingService = void 0;
const axios_1 = require("@nestjs/axios");
const common_2 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const event_emitter_1 = require("@nestjs/event-emitter");
let MessagingService = MessagingService_1 = class MessagingService {
    httpService;
    urlApiGzappy = process.env.GZAPPY_API_URL;
    bearerToken = process.env.GZAPPY_BEARER_TOKEN;
    publicId = process.env.GZAPPY_PUBLIC_ID;
    adminCellphone = process.env.ADMIN_CELLPHONE;
    logger = new common_2.Logger(MessagingService_1.name);
    constructor(httpService) {
        this.httpService = httpService;
    }
    async sendWhatsappText(sendMessageDto) {
        if (!this.urlApiGzappy || !this.bearerToken || !this.publicId) {
            this.logger.error('Credenciais da Gzappy (URL, Bearer Token ou Public ID ) não estão configuradas.');
            return;
        }
        const payload = {
            phone: sendMessageDto.cellphone,
            message: sendMessageDto.message
        };
        const headers = {
            Authorization: `Bearer ${this.bearerToken}`,
            'Content-Type': 'application/json',
        };
        try {
            await (0, rxjs_1.firstValueFrom)(this.httpService.post(this.urlApiGzappy + '/message/send-text', payload, { headers }));
            this.logger.log(`Mensagem de WhatsApp enviada com sucesso para ${sendMessageDto.cellphone}`);
        }
        catch (error) {
            this.logger.error(`Falha ao enviar mensagem de WhatsApp para ${sendMessageDto.message}`, error.response?.data || error.message);
            throw new Error;
        }
    }
    async handleUserCreated({ userName, cellphone }) {
        if (!userName || !cellphone)
            return;
        const message = `Olá, ${userName}! Boas notícias!\n\n` +
            `🎉 Sua conta na plataforma de pedidos das lojas Croissant & CIA acaba de ser criada com sucesso!\n\n` +
            `Continue conosco em https://www.pedidoscroissant.com.br e conheça nossos salgados geniais. `;
        await this.sendWhatsappText({
            cellphone: cellphone,
            message,
        });
    }
    async handleOrderAccepted({ cellphone }) {
        if (!cellphone)
            return;
        const message = `A loja já aprovou o seu pedido na plataforma Pedidos Croissant\n\n` +
            `Finalize o pagamento acessando sua conta em https://pedidoscroissant.com.br e em breve poderá deliciar-se com nossos maravilhosos salgados geniais`;
        await this.sendWhatsappText({
            cellphone: cellphone,
            message
        });
    }
    async handleQuotationAccepted({ cellphone }) {
        if (!cellphone)
            return;
        const message = `Seu pedido foi aceito e já chamamos um entregador para leva-lo até você o mais rápido o possível\n\n` +
            `Assim que seu pedido sair para entrega iremos avisa-lo.`;
        await this.sendWhatsappText({
            cellphone,
            message
        });
    }
    async handleOrderRejected({ cellphone, message }) {
        if (!cellphone)
            return;
        await this.sendWhatsappText({ cellphone, message });
    }
    async handleNotifyStore({ cellphone, message }) {
        if (!cellphone || !message)
            return;
        await this.sendWhatsappText({
            cellphone,
            message
        });
    }
    async handleForgorPassword({ cellphone, code }) {
        if (!cellphone || !code)
            return;
        const message = `Recebemos um pedido de troca senha para o seu e-mail.\n\n` +
            `Na página de recuperação de senha digite esse código *${code}*\n\n` +
            `IMPORTANTE: Se você não reconhece essa solicitação considere acessar sua conta e modificar a senha, além de entrar em contato conosco.`;
        await this.sendWhatsappText({
            cellphone,
            message
        });
    }
    async handleNeedMaintanance({ cellphone, message }) {
        if (!cellphone || !message)
            return;
        await this.sendWhatsappText({
            cellphone,
            message
        });
    }
};
exports.MessagingService = MessagingService;
__decorate([
    (0, event_emitter_1.OnEvent)('user.created'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleUserCreated", null);
__decorate([
    (0, event_emitter_1.OnEvent)('order.accepted_awaiting_payment'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleOrderAccepted", null);
__decorate([
    (0, event_emitter_1.OnEvent)('quotation.accepted'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleQuotationAccepted", null);
__decorate([
    (0, event_emitter_1.OnEvent)('order.reject'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleOrderRejected", null);
__decorate([
    (0, event_emitter_1.OnEvent)('notify.store'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleNotifyStore", null);
__decorate([
    (0, event_emitter_1.OnEvent)('forgot.password'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleForgorPassword", null);
__decorate([
    (0, event_emitter_1.OnEvent)('need.maintanance'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], MessagingService.prototype, "handleNeedMaintanance", null);
exports.MessagingService = MessagingService = MessagingService_1 = __decorate([
    (0, common_2.Injectable)(),
    __metadata("design:paramtypes", [axios_1.HttpService])
], MessagingService);
//# sourceMappingURL=messaging.service.js.map