"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersController = void 0;
const common_2 = require("@nestjs/common");
const orders_service_1 = require("./orders.service");
const enum_1 = require("../../shared/enums/enum");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const checkout_dto_1 = require("./dto/checkout.dto");
let OrdersController = class OrdersController {
    ordersService;
    constructor(ordersService) {
        this.ordersService = ordersService;
    }
    findAllByUser(currentUser) {
        return this.ordersService.findAllByUser(currentUser.id);
    }
    findAllProductsByOrderId(orderId, currentUser) {
        return this.ordersService.findAllProductsByOrderId(currentUser.id, +orderId);
    }
    findAll() {
        return this.ordersService.findAll();
    }
    findAllByStatus(status) {
        return this.ordersService.findAllByStatus(status);
    }
    restrictFindAllProductsByOrderId(orderId) {
        return this.ordersService.restrictFindAllProductsByOrderId(+orderId);
    }
    createQRcode(currentUser) {
        return this.ordersService.createQRcode(currentUser.id);
    }
    statusPaied(paymentId) {
        return this.ordersService.statusPaied(paymentId);
    }
    checkout(currentUser, chechkoutDto) {
        return this.ordersService.checkout(currentUser.id, chechkoutDto);
    }
    changeOrderStatusById(orderId, status) {
        return this.ordersService.changeOrderStatusById(+orderId, status);
    }
};
exports.OrdersController = OrdersController;
__decorate([
    (0, common_2.Get)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "findAllByUser", null);
__decorate([
    (0, common_2.Get)(':orderId/detalhe-pedido'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('orderId')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "findAllProductsByOrderId", null);
__decorate([
    (0, common_2.Get)('/todos'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/todos-por-status'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __param(0, (0, common_2.Query)('status', new common_2.ParseEnumPipe(enum_1.Status))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "findAllByStatus", null);
__decorate([
    (0, common_2.Get)(':orderId/produtos'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __param(0, (0, common_2.Param)('orderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "restrictFindAllProductsByOrderId", null);
__decorate([
    (0, common_2.Get)('/qrcode'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "createQRcode", null);
__decorate([
    (0, common_2.Get)('/status/:paymentId'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('paymentId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "statusPaied", null);
__decorate([
    (0, common_2.Patch)('/finalizar/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, checkout_dto_1.CheckoutDto]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "checkout", null);
__decorate([
    (0, common_2.Patch)(':orderId'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __param(0, (0, common_2.Param)('orderId')),
    __param(1, (0, common_2.Query)('status', new common_2.ParseEnumPipe(enum_1.Status))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], OrdersController.prototype, "changeOrderStatusById", null);
exports.OrdersController = OrdersController = __decorate([
    (0, common_2.Controller)('pedidos'),
    __metadata("design:paramtypes", [orders_service_1.OrdersService])
], OrdersController);
//# sourceMappingURL=orders.controller.js.map