import { CreateCupomDto } from './dto/create-cupom.dto';
import { UpdateCupomDto } from './dto/update-cupom.dto';
import { Repository } from 'typeorm';
import { Cupom } from './entities/cupom.entity';
import { Order } from '../orders/entities/order.entity';
import { OrderProduct } from '../orders/entities/order_product.entity';
export declare class CupomService {
    private cupomRepository;
    private orderRepository;
    private orderProductRepository;
    constructor(cupomRepository: Repository<Cupom>, orderRepository: Repository<Order>, orderProductRepository: Repository<OrderProduct>);
    create(createCupomDto: CreateCupomDto): Promise<Cupom>;
    descont(orderId: number, codigo: string): Promise<Order>;
    removeDescont(orderId: number): Promise<Order>;
    findAll(): Promise<Cupom[]>;
    findOne(id: number): string;
    update(id: number, updateCupomDto: UpdateCupomDto): Promise<import("typeorm").UpdateResult>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
}
