"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CourseController = void 0;
const common_2 = require("@nestjs/common");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const enum_1 = require("../../shared/enums/enum");
const platform_express_1 = require("@nestjs/platform-express");
const path_1 = require("path");
const courses_service_1 = require("./courses.service");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
let CourseController = class CourseController {
    courseService;
    constructor(courseService) {
        this.courseService = courseService;
    }
    async create(body, file) {
        let createCourseDto;
        if (body.data) {
            try {
                createCourseDto = JSON.parse(body.data);
            }
            catch (error) {
                throw new common_2.BadRequestException('Formato JSON inválido no campo "data"');
            }
        }
        else {
            createCourseDto = body;
        }
        if (file) {
            const thumbnailUrl = await this.courseService.uploadImageToS3(file, file.originalname);
            createCourseDto.thumbnail = thumbnailUrl;
        }
        return this.courseService.create(createCourseDto);
    }
    async completeLesson(courseId, classId, user) {
        return this.courseService.completeLesson(courseId, classId, user.id);
    }
    async courseProgress(courseId, user) {
        return this.courseService.courseProgress(user.id, courseId);
    }
    async findAllByUser(user) {
        return this.courseService.findAllByUser(user.id);
    }
    async findOneByUser(courseId, user) {
        return this.courseService.findOneByUser(courseId, user.id);
    }
    findAll() {
        return this.courseService.findAll();
    }
    findAllForManagement() {
        return this.courseService.findAllForManagement();
    }
    findOne(id) {
        return this.courseService.findOne(+id);
    }
    findOneForManagement() {
        return this.courseService.findOneForManagement();
    }
    async update(id, body, file) {
        console.log("FILE CONTROLLER ", file);
        let parsedDto;
        try {
            parsedDto = JSON.parse(body.data);
        }
        catch (error) {
            throw new common_2.BadRequestException('Erro ao processar dados do formulário');
        }
        if (file) {
            const ext = (0, path_1.extname)(file.originalname);
            const fileName = `${Date.now()}-${Math.round(Math.random() * 1e9)}${ext}`;
            try {
                parsedDto.thumbnail = fileName;
            }
            catch (error) {
                throw new common_2.BadRequestException('Falha ao enviar imagem para o S3: ' + error);
            }
        }
        return this.courseService.update(+id, parsedDto);
    }
    remove(id) {
        return this.courseService.remove(+id);
    }
    findCourseWithClasses() {
        return this.courseService.findCourseWithClasses();
    }
    findCourseByIdWithClasses(id) {
        return this.courseService.findCourseByIdWithClasses(id);
    }
};
exports.CourseController = CourseController;
__decorate([
    (0, common_2.Post)('/registro'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "create", null);
__decorate([
    (0, common_2.Patch)(':courseId/class/:classId/complete'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('courseId', common_2.ParseIntPipe)),
    __param(1, (0, common_2.Param)('classId', common_2.ParseIntPipe)),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "completeLesson", null);
__decorate([
    (0, common_2.Get)(':courseId/progress'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('courseId', common_2.ParseIntPipe)),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "courseProgress", null);
__decorate([
    (0, common_2.Get)('/user'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "findAllByUser", null);
__decorate([
    (0, common_2.Get)('/user/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "findOneByUser", null);
__decorate([
    (0, common_2.Get)('/'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findAllForManagement", null);
__decorate([
    (0, common_2.Get)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findOne", null);
__decorate([
    (0, common_2.Get)(':id/restrito'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMIN, enum_1.Roles.ADMECOMMERCE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findOneForManagement", null);
__decorate([
    (0, common_2.Patch)('editar/:id'),
    (0, common_2.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __param(2, (0, common_2.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, Object]),
    __metadata("design:returntype", Promise)
], CourseController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "remove", null);
__decorate([
    (0, common_2.Get)('/classes'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findCourseWithClasses", null);
__decorate([
    (0, common_2.Get)(':id/classes'),
    __param(0, (0, common_2.Param)('id', common_2.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], CourseController.prototype, "findCourseByIdWithClasses", null);
exports.CourseController = CourseController = __decorate([
    (0, common_2.Controller)('course'),
    __metadata("design:paramtypes", [courses_service_1.CourseService])
], CourseController);
//# sourceMappingURL=courses.controller.js.map