"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchersService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const watcher_entity_1 = require("./entities/watcher.entity");
const typeorm_2 = require("typeorm");
const user_entity_1 = require("../../shared/users/entities/user.entity");
let WatchersService = class WatchersService {
    watcherRepository;
    userRepository;
    constructor(watcherRepository, userRepository) {
        this.watcherRepository = watcherRepository;
        this.userRepository = userRepository;
    }
    async create(id, createWatcherDto) {
        const user = await this.userRepository.findOneBy({ email: createWatcherDto.email });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado pelo e-mail informado");
        }
        const watcherExist = await this.watcherRepository.findOne({
            where: {
                user_owner: { id },
                user_watcher: { id: user.id }
            }
        });
        if (watcherExist) {
            throw new common_2.ConflictException("Obsevador já atrelado ao proprieário");
        }
        const watcher = this.watcherRepository.create({
            user_owner: { id },
            user_watcher: { id: user.id }
        });
        return this.watcherRepository.save(watcher);
    }
    async findAllByOwner(id) {
        const user = await this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        return await this.watcherRepository
            .createQueryBuilder('watcher')
            .innerJoin('watcher.user_owner', 'userOwner')
            .innerJoin('watcher.user_watcher', 'userWatcher')
            .select([
            'watcher.id AS id',
            'userWatcher.document AS document',
            'userWatcher.company_name AS company_name',
            'userWatcher.user_name AS user_name',
            'userWatcher.email AS email',
            'userWatcher.cellphone AS cellphone'
        ])
            .where('owner_id = :id', { id })
            .getRawMany();
    }
    async findAllByWatcher(id) {
        const user = this.userRepository.findOneBy({ id });
        if (!user) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        try {
            return await this.watcherRepository
                .createQueryBuilder('watcher')
                .innerJoinAndSelect('watcher.user_owner', 'ownerUser')
                .select([
                'watcher.id AS id',
                'ownerUser.company_name AS company_name',
                'ownerUser.user_name AS user_name'
            ])
                .where('watcher_id = :id', { id })
                .getRawMany();
        }
        catch (error) {
            throw new common_2.BadRequestException("Não foi possível retornar a de usuários assistidos");
        }
    }
    async remove(id, watcherId) {
        const user = await this.userRepository.findOneBy({ id });
        const watcher = await this.watcherRepository.findOne({
            where: [
                {
                    id: watcherId,
                    user_owner: { id }
                },
                {
                    id: watcherId,
                    user_watcher: { id }
                }
            ]
        });
        if (!user || !watcher) {
            throw new common_2.NotFoundException("Usuário não encontrado");
        }
        return await this.watcherRepository.remove(watcher);
    }
};
exports.WatchersService = WatchersService;
exports.WatchersService = WatchersService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(watcher_entity_1.Watcher)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], WatchersService);
//# sourceMappingURL=watchers.service.js.map