"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupController = void 0;
const common_2 = require("@nestjs/common");
const group_service_1 = require("./group.service");
const create_group_dto_1 = require("./dto/create-group.dto");
const update_group_dto_1 = require("./dto/update-group.dto");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
let GroupController = class GroupController {
    groupsService;
    constructor(groupsService) {
        this.groupsService = groupsService;
    }
    create(createGroupDto, currentUser) {
        return this.groupsService.create(createGroupDto, currentUser.id);
    }
    findAll(currentUser) {
        return this.groupsService.findAllByUser(currentUser.id);
    }
    findOne(groupId, currentUser) {
        return this.groupsService.findOne(+groupId, currentUser.id);
    }
    update(groupId, updateGroupDto, currentUser) {
        return this.groupsService.update(+groupId, updateGroupDto, currentUser.id);
    }
    remove(groupId, currentUser) {
        return this.groupsService.remove(+groupId, currentUser.id);
    }
};
exports.GroupController = GroupController;
__decorate([
    (0, common_2.Post)('/registro'),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_group_dto_1.CreateGroupDto, Object]),
    __metadata("design:returntype", void 0)
], GroupController.prototype, "create", null);
__decorate([
    (0, common_2.Get)(),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], GroupController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)(':groupId'),
    __param(0, (0, common_2.Param)('groupId')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", void 0)
], GroupController.prototype, "findOne", null);
__decorate([
    (0, common_2.Patch)(':groupId'),
    __param(0, (0, common_2.Param)('groupId')),
    __param(1, (0, common_2.Body)()),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_group_dto_1.UpdateGroupDto, Object]),
    __metadata("design:returntype", void 0)
], GroupController.prototype, "update", null);
__decorate([
    (0, common_2.Delete)(':groupId'),
    __param(0, (0, common_2.Param)('groupId')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], GroupController.prototype, "remove", null);
exports.GroupController = GroupController = __decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_2.Controller)('grupos'),
    __metadata("design:paramtypes", [group_service_1.GroupService])
], GroupController);
//# sourceMappingURL=group.controller.js.map