import { CreateFilesDto } from './dto/create-files.dto';
import { CreateFolderDto } from './dto/create-path.dto';
import { Files } from './entities/files.entity';
import { Repository } from 'typeorm';
import { Folder } from './entities/path.entity';
import { UpdatePathDto } from './dto/update-path.dto';
export declare class FilesService {
    private filesRepository;
    private folderRepository;
    constructor(filesRepository: Repository<Files>, folderRepository: Repository<Folder>);
    create(file: Express.Multer.File, createFilesDto: CreateFilesDto): Promise<string>;
    createFolder(createFolderDto: CreateFolderDto): Promise<Folder>;
    getRaiz(currentUser: any): Promise<Folder[]>;
    getRelation(pastaRaizId: number, currentUser: any): Promise<{
        children: Folder[];
        files: {
            fileData: {
                id: number;
                file_name: string;
                name: string;
                version: string;
                description: string;
                type: string;
                size: number;
                folder: Folder;
                created_on: Date;
            };
        }[];
    }>;
    deleteFolder(id: number): Promise<void>;
    editPath(id: number, updateFolderDto: UpdatePathDto): Promise<{
        oldPath: string;
        newPath: string;
    }>;
    findAll(): Promise<Files[]>;
    getFilePath(id: number): Promise<string>;
    remove(id: number): Promise<boolean>;
}
