"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateFilesDto = void 0;
const swagger_2 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
class CreateFilesDto {
    file_name;
    version;
    description;
    folder;
}
exports.CreateFilesDto = CreateFilesDto;
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Título do arquivo', type: String, required: true }),
    (0, class_validator_1.IsNotEmpty)({ message: 'O titulo do arquivo não pode ser nulo' }),
    (0, class_validator_1.IsString)({ message: 'O título do arquivo de ser uma texto válido' }),
    __metadata("design:type", String)
], CreateFilesDto.prototype, "file_name", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Versão do arquivo', type: String, required: true }),
    (0, class_validator_1.Matches)(/^\d+(\.\d+)?$/, { message: 'A versão do arquivo deve ser um número válido, como "1.0" ou "2.5".' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'A versão é obrigatória ' }),
    __metadata("design:type", String)
], CreateFilesDto.prototype, "version", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'Descrição do arquivo', type: String, required: true }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)({ message: 'A descrição de arquivo deve ser um texto válido' }),
    __metadata("design:type", String)
], CreateFilesDto.prototype, "description", void 0);
__decorate([
    (0, swagger_2.ApiProperty)({ description: 'id da pasta pai', type: String, required: true }),
    (0, class_validator_1.IsNotEmpty)({ message: 'o id da pasta pai deve ser informado' }),
    __metadata("design:type", String)
], CreateFilesDto.prototype, "folder", void 0);
//# sourceMappingURL=create-files.dto.js.map