"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentsController = void 0;
const common_2 = require("@nestjs/common");
const equipaments_service_1 = require("./equipaments.service");
const update_equipament_dto_1 = require("./dto/update-equipament.dto");
const auth_guard_1 = require("../../shared/auth/auth.guard");
const permissions_guards_1 = require("../../shared/auth/permissions.guards");
const required_roles_decorator_1 = require("../../shared/auth/required-roles.decorator");
const enum_1 = require("../../shared/enums/enum");
const role_guard_1 = require("../../shared/auth/role/role.guard");
const swagger_2 = require("@nestjs/swagger");
const create_equipament_dto_1 = require("./dto/create-equipament.dto");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const add_equipament_to_group_dto_1 = require("./dto/add-equipament-to-group.dto");
let EquipamentsController = class EquipamentsController {
    equipamentsService;
    constructor(equipamentsService) {
        this.equipamentsService = equipamentsService;
    }
    async createFirstConnection(dto) {
        return this.equipamentsService.createFirstConnection(dto);
    }
    async addEquipamentToGroup(currentUser, addEquipamentToGroupDto) {
        return this.equipamentsService.addEquipamentToGroup(currentUser.id, addEquipamentToGroupDto);
    }
    countAll() {
        return this.equipamentsService.countAll();
    }
    findAll() {
        return this.equipamentsService.findAll();
    }
    ping(mac) {
        return this.equipamentsService.ping(mac);
    }
    findSchedulesByEquipament(equipId, id) {
        return this.equipamentsService.findSchedulesByEquipament(+equipId, +id);
    }
    findMonitoredEquipaments(id) {
        return this.equipamentsService.findMonitoredEquipaments(+id);
    }
    countForCards() {
        return this.equipamentsService.countForCards();
    }
    findAllByUser(id) {
        return this.equipamentsService.findAllByUser(+id);
    }
    findOne(id, type) {
        return this.equipamentsService.findOne(+id, type?.toLowerCase() ?? '');
    }
    countByType(type) {
        return this.equipamentsService.countByType(type?.toLowerCase() ?? '');
    }
    updateStatus(dto) {
        return this.equipamentsService.updateStatus(dto);
    }
    update(equipId, id, updateEquipamentDto) {
        return this.equipamentsService.update(+equipId, +id, updateEquipamentDto);
    }
    unlinkDeviceByUser(equipId, id) {
        return this.equipamentsService.unlinkDeviceByUser(+equipId, +id);
    }
    updateScheduleByEquipament(equipId, id, updateSchedulesDto) {
        return this.equipamentsService.updateScheduleByEquipament(+equipId, +id, updateSchedulesDto);
    }
    updateScheduleByGroup(currentUser, updateScheduleByGroupDto) {
        return this.equipamentsService.updateScheduleByGroup(currentUser.id, updateScheduleByGroupDto);
    }
    removeEquipamentFromGroup(currentUser, removeEquipamentFromGroupDto) {
        return this.equipamentsService.removeEquipamentFromGroup(currentUser.id, removeEquipamentFromGroupDto);
    }
    remove(id, equipId) {
        return this.equipamentsService.remove(+equipId, +id);
    }
};
exports.EquipamentsController = EquipamentsController;
__decorate([
    (0, common_2.Post)('/primeiro-registro/'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_equipament_dto_1.CreateEquipamentFirstConnectionDto]),
    __metadata("design:returntype", Promise)
], EquipamentsController.prototype, "createFirstConnection", null);
__decorate([
    (0, common_2.Post)('/grupo'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, add_equipament_to_group_dto_1.AddEquipamentToGroupDto]),
    __metadata("design:returntype", Promise)
], EquipamentsController.prototype, "addEquipamentToGroup", null);
__decorate([
    (0, common_2.Get)('/'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "countAll", null);
__decorate([
    (0, common_2.Get)('/lista-todos'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "findAll", null);
__decorate([
    (0, common_2.Get)('/ping/:mac'),
    __param(0, (0, common_2.Param)('mac')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "ping", null);
__decorate([
    (0, common_2.Get)('/programar-individual/:equipId/usuario/:id'),
    __param(0, (0, common_2.Param)('equipId')),
    __param(1, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "findSchedulesByEquipament", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Get)('/observados/:id'),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "findMonitoredEquipaments", null);
__decorate([
    (0, common_2.Get)('/cards-admin'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "countForCards", null);
__decorate([
    (0, common_2.Get)('/usuario/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "findAllByUser", null);
__decorate([
    (0, common_2.Get)(':id/:type'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Param)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "findOne", null);
__decorate([
    (0, common_2.Get)(':type'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, role_guard_1.RoleGuard),
    (0, required_roles_decorator_1.RequiredRoles)(enum_1.Roles.ADMVISO360, enum_1.Roles.ADMIN),
    __param(0, (0, common_2.Param)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "countByType", null);
__decorate([
    (0, common_2.Patch)('/status'),
    __param(0, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [update_equipament_dto_1.UpdateStatusDto]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "updateStatus", null);
__decorate([
    (0, common_2.Patch)(':equipId/usuario/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('equipId')),
    __param(1, (0, common_2.Param)('id')),
    __param(2, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, update_equipament_dto_1.UpdateEquipamentDto]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "update", null);
__decorate([
    (0, common_2.Patch)('desvincular/:equipId/usuario/:id'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    __param(0, (0, common_2.Param)('equipId')),
    __param(1, (0, common_2.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "unlinkDeviceByUser", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Patch)('programar-individual/:equipId/usuario/:id'),
    __param(0, (0, common_2.Param)('equipId')),
    __param(1, (0, common_2.Param)('id')),
    __param(2, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, update_equipament_dto_1.UpdateSchedulesDto]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "updateScheduleByEquipament", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_2.Patch)('programar-em-grupo/'),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, update_equipament_dto_1.UpdateSchedulesByGroupDto]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "updateScheduleByGroup", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_2.Put)('/grupo'),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __param(1, (0, common_2.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, add_equipament_to_group_dto_1.AddEquipamentToGroupDto]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "removeEquipamentFromGroup", null);
__decorate([
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard, permissions_guards_1.PermissionsGuard),
    (0, common_2.Delete)(':equipId/usuario/:id/'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Param)('equipId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], EquipamentsController.prototype, "remove", null);
exports.EquipamentsController = EquipamentsController = __decorate([
    (0, swagger_2.ApiTags)('Equipamentos'),
    (0, common_2.Controller)('equipamentos'),
    __metadata("design:paramtypes", [equipaments_service_1.EquipamentsService])
], EquipamentsController);
//# sourceMappingURL=equipaments.controller.js.map