"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactsService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const contact_entity_1 = require("./entities/contact.entity");
const typeorm_2 = require("typeorm");
let ContactsService = class ContactsService {
    contactRepository;
    constructor(contactRepository) {
        this.contactRepository = contactRepository;
    }
    async create(userId, createContactDto) {
        const results = [];
        await this.contactRepository.delete({ user: { id: userId } });
        for (const dto of createContactDto) {
            let contact = await this.contactRepository.findOne({
                where: { cellphone: dto.cellphone }
            });
            if (!contact) {
                contact = this.contactRepository.create({
                    ...dto,
                    user: { id: userId }
                });
                const saved = await this.contactRepository.save(contact);
                results.push(saved);
            }
            else {
                results.push({ cellphone: dto.cellphone, message: "Contato já existente!" });
            }
        }
        return results;
    }
    findAllByUser(userId) {
        const contact = this.contactRepository.find({
            where: { user: { id: userId } },
        });
        return contact;
    }
    findOneBy(id) {
        return this.contactRepository.findOneBy({ id });
    }
    async update(userId, id, updateContactDto) {
        const contact = await this.contactRepository.findOne({
            where: {
                id: id,
                user: { id: userId }
            }
        });
        if (!contact) {
            throw new common_2.NotFoundException("Contato não encontrado");
        }
        this.contactRepository.merge(contact, updateContactDto);
        return this.contactRepository.save(contact);
    }
};
exports.ContactsService = ContactsService;
exports.ContactsService = ContactsService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(contact_entity_1.Contact)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ContactsService);
//# sourceMappingURL=contacts.service.js.map