"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersService = void 0;
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const typeorm_2 = require("typeorm");
const order_entity_1 = require("./entities/order.entity");
const order_product_entity_1 = require("./entities/order_product.entity");
const order_transaction_entity_1 = require("./entities/order_transaction.entity");
const enum_1 = require("../../shared/enums/enum");
const asaas_service_1 = require("../asaas/asaas.service");
const checkout_dto_1 = require("./dto/checkout.dto");
const users_service_1 = require("../../shared/users/users.service");
const product_entity_1 = require("../products/entities/product.entity");
const event_emitter_1 = require("@nestjs/event-emitter");
const mailer_1 = require("@nestjs-modules/mailer");
const creditcard_entity_1 = require("../creditcard/entities/creditcard.entity");
let OrdersService = class OrdersService {
    orderRepository;
    userRepository;
    orderProductRepository;
    orderTransactionsRepository;
    productRepository;
    creditcardRepository;
    asaasService;
    usersService;
    eventEmitter;
    mailerService;
    constructor(orderRepository, userRepository, orderProductRepository, orderTransactionsRepository, productRepository, creditcardRepository, asaasService, usersService, eventEmitter, mailerService) {
        this.orderRepository = orderRepository;
        this.userRepository = userRepository;
        this.orderProductRepository = orderProductRepository;
        this.orderTransactionsRepository = orderTransactionsRepository;
        this.productRepository = productRepository;
        this.creditcardRepository = creditcardRepository;
        this.asaasService = asaasService;
        this.usersService = usersService;
        this.eventEmitter = eventEmitter;
        this.mailerService = mailerService;
    }
    async findAllByUser(currentUserId) {
        console.log(currentUserId);
        const orders = await this.orderRepository.find({
            where: {
                user: { id: currentUserId },
            }
        });
        return (!orders) ? { message: "Nenhum pedido encontrado" } : orders;
    }
    async findAllProductsByOrderId(currentUserId, orderId) {
        const order = await this.orderRepository.findOne({
            where: {
                id: orderId,
                user: { id: currentUserId }
            },
            relations: ['order_product', 'order_product.product']
        });
        if (!order) {
            throw new common_2.NotFoundException(`Não foi possível localizar o pedido ${orderId} para o usuário ${currentUserId}`);
        }
        return order;
    }
    async findAll() {
        const orders = await this.orderRepository.find();
        return orders;
    }
    async findAllByStatus(status) {
        const orders = await this.orderRepository.find({
            where: {
                status: status
            }
        });
        return orders;
    }
    async restrictFindAllProductsByOrderId(orderId) {
        const orders = await this.orderRepository
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.order_product', 'orderProduct')
            .leftJoinAndSelect('orderProduct.product', 'product')
            .where('order.id = :orderId', { orderId })
            .getMany();
        return orders;
    }
    async checkout(currentUserId, checkoutDto) {
        const user = await this.usersService.findUserById(currentUserId);
        const cartExist = await this.findShoppingCartByUser(currentUserId);
        if (!cartExist) {
            throw new common_2.NotFoundException("Ops. Nenhum carrinho encontrado para esse usuário");
        }
        await this.orderRepository.update(cartExist.id, {
            payment_method: checkoutDto.paymentMethod,
            status: enum_1.Status.PENDING_PAYMENT,
        });
        const order = await this.orderTransactionsRepository.create({
            order: cartExist,
        });
        await this.orderTransactionsRepository.save(order);
        const updatedOrder = await this.orderRepository.findOne({
            where: {
                id: cartExist.id
            },
            relations: ['user']
        });
        if (!updatedOrder) {
            throw new common_2.NotFoundException('Order not found after update.');
        }
        if (checkoutDto.paymentMethod === checkout_dto_1.PaymentMethod.CREDIT_CARD) {
            const existCard = await this.creditcardRepository.findOne({
                where: { user: { id: currentUserId },
                    credit_card_number: checkoutDto.credit_card_number },
            });
            if (!existCard) {
                throw new Error("Cartão de crédito não encontrado");
            }
            const creditCard = await this.asaasService.createCreditCardPayment({ user: user, value: updatedOrder.total_amount, orderId: updatedOrder.id, creditCard: existCard });
            await this.orderRepository.update(updatedOrder.id, {
                paymentId: creditCard.paymentId
            });
            await this.enviarEmailPedidoCriado(updatedOrder);
            this.eventEmitter.emit('order.placed', updatedOrder);
            this.eventEmitter.emit('notify.store', { cellphone: updatedOrder?.user.cellphone, message: "Seu pedido foi criado com sucesso e está aguardando pagamento!" });
        }
        else {
            const pix = await this.asaasService.createPixCharge({ user: user, value: updatedOrder.total_amount, orderId: updatedOrder.id });
            await this.orderRepository.update(updatedOrder.id, {
                paymentId: pix.paymentId
            });
            await this.enviarEmailPedidoCriado(updatedOrder);
            this.eventEmitter.emit('order.placed', updatedOrder);
            this.eventEmitter.emit('notify.store', { cellphone: updatedOrder?.user.cellphone, message: "Seu pedido foi criado com sucesso e está aguardando pagamento!" });
            return pix;
        }
    }
    async createQRcode(currentUserId) {
        const order = await this.orderRepository.findOne({
            where: {
                user: { id: currentUserId },
                status: enum_1.Status.PENDING_PAYMENT
            },
            relations: ['order_product', 'order_product.product']
        });
        if (!order) {
            throw new common_2.NotFoundException("Nenhum pedido pendente de pagamento encontrado para este usuário.");
        }
        const qrcode = await this.asaasService.getPixQrCode(order.paymentId);
        return { qrcode: qrcode, paymentId: order.paymentId };
    }
    async statusPaied(paymentId) {
        const orders = await this.orderRepository.find({
            where: {
                paymentId: paymentId,
                status: enum_1.Status.FINISHED
            }
        });
        if (!orders) {
            return 'não pago';
        }
        return orders;
    }
    async changeOrderStatusById(id, status) {
        const order = await this.orderRepository.findOneBy({ id });
        if (!order) {
            throw new common_2.NotFoundException("Pedido não encontrado");
        }
        const orderStatusUpdated = order.status = status;
        await this.orderRepository.update(order.id, { status: orderStatusUpdated });
        return { message: "Status do pedido alterado com sucesso" };
    }
    async enviarEmailPedidoCriado(order) {
        await this.mailerService.sendMail({
            to: 'andrewfabiani24@gmail.com',
            subject: 'Um novo pedido foi criado!',
            template: './email',
            context: {
                orderId: order.id,
                totalAmount: order.total_amount,
            }
        });
        return 'Email enviado com sucesso';
    }
    async findShoppingCartByUser(userId) {
        const rows = await this.orderRepository
            .createQueryBuilder('order')
            .innerJoin('order.order_product', 'orderProduct')
            .innerJoin('orderProduct.product', 'product')
            .innerJoin('order.user', 'user')
            .select([
            'order.id AS order_id',
            'order.status AS order_status',
            'order.total_amount AS order_total_amount',
            'order.total_items AS order_total_items',
            'user.id AS user_id',
            'orderProduct.id AS order_product_id',
            'orderProduct.quantity AS order_product_quantity',
            'orderProduct.unit_price AS order_product_unit_price',
        ])
            .where('order.status = :status AND user.id = :userId', {
            status: enum_1.Status.OPEN,
            userId,
        })
            .getRawMany();
        if (!rows.length)
            return null;
        const order = {
            id: rows[0].order_id,
            status: rows[0].order_status,
            total_amount: rows[0].order_total_amount,
            total_items: rows[0].order_total_items,
            user_id: rows[0].user_id,
            products: rows.map((row) => ({
                id: row.order_product_id,
                quantity: row.order_product_quantity,
                unit_price: row.order_product_unit_price,
            })),
        };
        return order;
    }
    async findOrderById(orderId) {
        const itemsExist = await this.orderProductRepository.find({
            where: {
                order: { id: orderId }
            },
            relations: ['product']
        });
        if (!itemsExist)
            throw new common_2.NotFoundException("Nenhum produto encontrado para o pedido informado");
        return itemsExist;
    }
    async verifyStock(orderId) {
        const items = await this.findOrderById(orderId.orderId);
        const productsName = [];
        for (let item of items) {
            item.product.quantity = item.product.quantity - item.quantity;
            await this.productRepository.save(item.product);
            if (item.product.quantity <= item.product.safety_stock) {
                productsName.push(item.product.name);
            }
        }
        if (productsName.length > 0) {
            this.eventEmitter.emit('lower.stock', {
                productsName
            });
        }
    }
};
exports.OrdersService = OrdersService;
__decorate([
    (0, event_emitter_1.OnEvent)('payment.confirmed'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OrdersService.prototype, "verifyStock", null);
exports.OrdersService = OrdersService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(2, (0, typeorm_1.InjectRepository)(order_product_entity_1.OrderProduct)),
    __param(3, (0, typeorm_1.InjectRepository)(order_transaction_entity_1.OrderTransactions)),
    __param(4, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(5, (0, typeorm_1.InjectRepository)(creditcard_entity_1.Creditcard)),
    __param(6, (0, common_2.Inject)((0, common_2.forwardRef)(() => asaas_service_1.AsaasService))),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        asaas_service_1.AsaasService,
        users_service_1.UsersService,
        event_emitter_1.EventEmitter2,
        mailer_1.MailerService])
], OrdersService);
//# sourceMappingURL=orders.service.js.map