"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreteInfoController = void 0;
const common_2 = require("@nestjs/common");
const frete_info_service_1 = require("./frete_info.service");
const create_frete_info_dto_1 = require("./dto/create-frete_info.dto");
const update_frete_info_dto_1 = require("./dto/update-frete_info.dto");
const current_user_decorator_1 = require("../../shared/users/current.user.decorator");
const auth_guard_1 = require("../../shared/auth/auth.guard");
let FreteInfoController = class FreteInfoController {
    freteInfoService;
    constructor(freteInfoService) {
        this.freteInfoService = freteInfoService;
    }
    create(createFreteInfoDto, currentUser) {
        return this.freteInfoService.create(createFreteInfoDto, currentUser);
    }
    findOne(currentUser) {
        return this.freteInfoService.findOne(currentUser);
    }
    update(id, updateFreteInfoDto, currentUser) {
        return this.freteInfoService.update(currentUser, +id, updateFreteInfoDto);
    }
};
exports.FreteInfoController = FreteInfoController;
__decorate([
    (0, common_2.Post)(),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_2.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_frete_info_dto_1.CreateFreteInfoDto, Object]),
    __metadata("design:returntype", void 0)
], FreteInfoController.prototype, "create", null);
__decorate([
    (0, common_2.Get)('/my-address'),
    (0, common_2.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], FreteInfoController.prototype, "findOne", null);
__decorate([
    (0, common_2.Patch)(':id'),
    __param(0, (0, common_2.Param)('id')),
    __param(1, (0, common_2.Body)()),
    __param(2, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_frete_info_dto_1.UpdateFreteInfoDto, Object]),
    __metadata("design:returntype", void 0)
], FreteInfoController.prototype, "update", null);
exports.FreteInfoController = FreteInfoController = __decorate([
    (0, common_2.Controller)('frete-info'),
    __metadata("design:paramtypes", [frete_info_service_1.FreteInfoService])
], FreteInfoController);
//# sourceMappingURL=frete_info.controller.js.map