import { UpdateDashboardDto } from './dto/update-dashboard.dto';
import { User } from 'src/shared/users/entities/user.entity';
import { Repository } from 'typeorm';
import { Order } from '../orders/entities/order.entity';
import { Course_payment } from '../course_payment/entities/course_payment.entity';
export declare class DashboardService {
    private readonly orderRepository;
    private readonly coursePaymentRepository;
    private readonly userRepository;
    constructor(orderRepository: Repository<Order>, coursePaymentRepository: Repository<Course_payment>, userRepository: Repository<User>);
    findAllRecentTransactions(): Promise<{
        recentTransactions: any[];
        totalMonth: number;
        totalEcommerce: number;
        totalEcommerceMonth: number;
        totalCoursePaymentMonth: number;
        totalCoursePayment: number;
        last12MonthsSales: {
            date: string;
            month: string;
            total: number;
        }[];
    }>;
    findAllTransactions(): Promise<{
        recentTransactions: any[];
        totalMonth: number;
        totalEcommerce: number;
        totalEcommerceMonth: number;
        totalCoursePaymentMonth: number;
        totalCoursePayment: number;
    }>;
    findOne(id: number): string;
    update(id: number, updateDashboardDto: UpdateDashboardDto): string;
    remove(id: number): string;
}
