"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateCreditChargeDto = exports.CreateChargeDto = void 0;
const class_validator_1 = require("class-validator");
const user_entity_1 = require("../../../shared/users/entities/user.entity");
const creditcard_entity_1 = require("../../creditcard/entities/creditcard.entity");
class ChargeCustomerDto {
    id;
    name;
    email;
    document;
    cellphone;
}
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], ChargeCustomerDto.prototype, "id", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ChargeCustomerDto.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsEmail)(),
    __metadata("design:type", String)
], ChargeCustomerDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ChargeCustomerDto.prototype, "document", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ChargeCustomerDto.prototype, "cellphone", void 0);
class CreateChargeDto {
    user;
    value;
    orderId;
}
exports.CreateChargeDto = CreateChargeDto;
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.IsNotEmptyObject)(),
    __metadata("design:type", user_entity_1.User)
], CreateChargeDto.prototype, "user", void 0);
__decorate([
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }, { message: 'O valor deve ser um número com no máximo duas casas decimais.' }),
    (0, class_validator_1.IsPositive)({ message: 'O valor da cobrança deve ser positivo.' }),
    __metadata("design:type", Number)
], CreateChargeDto.prototype, "value", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], CreateChargeDto.prototype, "orderId", void 0);
class CreateCreditChargeDto {
    user;
    creditCard;
    value;
    orderId;
}
exports.CreateCreditChargeDto = CreateCreditChargeDto;
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.IsNotEmptyObject)(),
    __metadata("design:type", user_entity_1.User)
], CreateCreditChargeDto.prototype, "user", void 0);
__decorate([
    (0, class_validator_1.IsObject)(),
    (0, class_validator_1.IsNotEmptyObject)(),
    __metadata("design:type", creditcard_entity_1.Creditcard)
], CreateCreditChargeDto.prototype, "creditCard", void 0);
__decorate([
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }, { message: 'O valor deve ser um número com no máximo duas casas decimais.' }),
    (0, class_validator_1.IsPositive)({ message: 'O valor da cobrança deve ser positivo.' }),
    __metadata("design:type", Number)
], CreateCreditChargeDto.prototype, "value", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.IsPositive)(),
    __metadata("design:type", Number)
], CreateCreditChargeDto.prototype, "orderId", void 0);
//# sourceMappingURL=create-asaas-dto.js.map