"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsaasService = void 0;
const axios_1 = require("@nestjs/axios");
const common_2 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const event_emitter_1 = require("@nestjs/event-emitter");
const user_entity_1 = require("../../shared/users/entities/user.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const enum_1 = require("../../shared/enums/enum");
const order_entity_1 = require("../orders/entities/order.entity");
const orders_service_1 = require("../orders/orders.service");
const encrypt_1 = require("../../utils/encrypt");
const course_payment_entity_1 = require("../course_payment/entities/course_payment.entity");
const creditcard_entity_1 = require("../creditcard/entities/creditcard.entity");
let AsaasService = class AsaasService {
    http;
    eventEmitter;
    ordersService;
    userRepository;
    creditcardRepository;
    orderRepositoty;
    course_paymentRepository;
    baseURL = process.env.ASAAS_BASE_URL;
    headers = {
        accept: 'application/json',
        access_token: process.env.ASAAS_API_KEY,
        'content-type': 'application/json',
    };
    constructor(http, eventEmitter, ordersService, userRepository, creditcardRepository, orderRepositoty, course_paymentRepository) {
        this.http = http;
        this.eventEmitter = eventEmitter;
        this.ordersService = ordersService;
        this.userRepository = userRepository;
        this.creditcardRepository = creditcardRepository;
        this.orderRepositoty = orderRepositoty;
        this.course_paymentRepository = course_paymentRepository;
    }
    async handlePaymentWebhook(payload) {
        const { event, payment } = payload;
        if (!event || !payment) {
            throw new common_2.BadRequestException('Payload do webhook inválido.');
        }
        if (event === 'PAYMENT_RECEIVED' || event === 'PAYMENT_CONFIRMED') {
            this.eventEmitter.emit('payment.confirmed', payment);
            const id = payment.id;
            const existCourse = await this.course_paymentRepository.findOne({
                where: {
                    asaasPaymentId: id,
                },
            });
            const existOrder = await this.orderRepositoty.findOne({
                where: {
                    paymentId: id,
                },
            });
            if (existCourse) {
                await this.course_paymentRepository.update(existCourse.id, {
                    status: "PAID",
                });
                this.eventEmitter.emit('course.payment.confirmed', {
                    orderId: existCourse.id,
                });
            }
            if (existOrder) {
                await this.orderRepositoty.update(existOrder.id, {
                    status: enum_1.Status.FINISHED
                });
                this.eventEmitter.emit('order.payment.confirmed', {
                    orderId: existOrder.id,
                });
            }
        }
    }
    async createPixCharge(createChargeDto) {
        const { user, value, orderId } = createChargeDto;
        console.log("value " + value);
        const customerId = await this.getOrCreateCustomer(user);
        console.log(customerId);
        const paymentPayload = {
            customer: customerId,
            billingType: 'PIX',
            value,
            dueDate: new Date().toISOString().slice(0, 10),
            description: `Pedido #${orderId}`,
            externalReference: String(orderId),
        };
        console.log("AQUI2");
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/lean/payments`, paymentPayload, { headers: this.headers }));
            console.log("AQUI3");
            const paymentId = response.data.id;
            const qrCodePayload = await this.getPixQrCode(paymentId);
            return {
                paymentId,
                qrCode: qrCodePayload.encodedImage,
                copyPaste: qrCodePayload.payload,
            };
        }
        catch (error) {
            console.error('Erro ao criar cobrança no Asaas:', error.response?.data || error.message);
            throw new common_2.BadRequestException('Não foi possível gerar a cobrança de pagamento.');
        }
    }
    async createPixChargeForCourse(createChargeDto) {
        const { user, value, orderId } = createChargeDto;
        console.log("value " + value);
        const customerId = await this.getOrCreateCustomer(user);
        const paymentPayload = {
            customer: customerId,
            billingType: 'PIX',
            value,
            dueDate: new Date().toISOString().slice(0, 10),
            description: `Curso com ID #${orderId}`,
            externalReference: String(orderId),
        };
        console.log("AQUI2 - Payload:", JSON.stringify(paymentPayload, null, 2));
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/payments`, paymentPayload, { headers: this.headers }));
            console.log("AQUI3 - Sucesso");
            const paymentId = response.data.id;
            console.log(paymentId);
            const qrCodePayload = await this.getPixQrCode(paymentId);
            return {
                paymentId,
                qrCode: qrCodePayload.encodedImage,
                copyPaste: qrCodePayload.payload,
            };
        }
        catch (error) {
            console.log("--- ENTROU NO CATCH ---");
            if (error.response) {
                console.error('Status do Erro:', error.response.status);
                console.error('Dados do Erro (Asaas):', JSON.stringify(error.response.data, null, 2));
            }
            else {
                console.error('Erro sem resposta (Rede/Código):', error.message);
            }
            throw new common_2.BadRequestException('Não foi possível gerar a cobrança de pagamento.');
        }
    }
    async createCreditCardPayment(createChargeDto) {
        const { user, value, orderId, creditCard } = createChargeDto;
        const customerId = await this.getOrCreateCustomer(user);
        const payload = {
            customer: customerId,
            billingType: 'CREDIT_CARD',
            creditCard: {
                holderName: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_holder_name),
                number: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_number),
                expiryMonth: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_month),
                expiryYear: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_year),
                ccv: encrypt_1.CryptoUtil.decrypt(creditCard.ccv),
            },
            value,
            dueDate: new Date().toISOString().slice(0, 10),
            description: `Pedido #${orderId}`,
            externalReference: String(orderId),
        };
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/payments`, payload, { headers: this.headers }));
            const paymentId = response.data.id;
            return { paymentId };
        }
        catch (error) {
            const asaasError = error.response?.data?.errors?.[0];
            const errorMessage = asaasError?.description || 'Não foi possível processar o pagamento com cartão de crédito.';
            const statusCode = error.response?.status || common_2.HttpStatus.BAD_REQUEST;
            console.error('Erro ao criar pagamento com cartão de crédito no Asaas:', error.response?.data || error.message);
            throw new common_2.HttpException(errorMessage, statusCode);
        }
    }
    async createCreditCardPaymentCourse(CreateCreditChargeDto) {
        const { user, value, orderId, creditCard } = CreateCreditChargeDto;
        const customerId = await this.getOrCreateCustomer(user);
        const payload = {
            customer: customerId,
            billingType: 'CREDIT_CARD',
            creditCard: {
                holderName: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_holder_name),
                number: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_number),
                expiryMonth: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_month),
                expiryYear: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_year),
                ccv: encrypt_1.CryptoUtil.decrypt(creditCard.ccv),
            },
            value,
            dueDate: new Date().toISOString().slice(0, 10),
            description: `Curso com ID#${orderId}`,
            externalReference: String(orderId),
        };
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/payments`, payload, { headers: this.headers }));
            const paymentId = response.data.id;
            return { paymentId };
        }
        catch (error) {
            const asaasError = error.response?.data?.errors?.[0];
            const errorMessage = asaasError?.description || 'Não foi possível processar o pagamento com cartão de crédito.';
            const statusCode = error.response?.status || common_2.HttpStatus.BAD_REQUEST;
            console.error('Erro ao criar pagamento com cartão de crédito no Asaas:', error.response?.data || error.message);
            throw new common_2.HttpException(errorMessage, statusCode);
        }
    }
    async getOrCreateCustomer(user) {
        if (user.asaas_customer_code) {
            return user.asaas_customer_code;
        }
        try {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.http.get(`${this.baseURL}/customers`, {
                headers: this.headers,
                params: { cpfCnpj: user.document },
            }));
            if (data.totalCount > 0) {
                const customerId = data.data[0].id;
                await this.userRepository.update(user.id, { asaas_customer_code: customerId });
                return customerId;
            }
            const { data: newCustomer } = await (0, rxjs_1.firstValueFrom)(this.http.post(`${this.baseURL}/customers`, {
                name: user.user_name,
                cpfCnpj: user.document,
                mobilePhone: user.cellphone,
            }, { headers: this.headers }));
            await this.userRepository.update(user.id, { asaas_customer_code: newCustomer.id });
            return newCustomer.id;
        }
        catch (error) {
            const status = error.response?.status || 500;
            const message = error.response?.data || error.message || 'Erro ao integrar com Asaas';
            console.error('Erro Asaas:', message);
            throw new common_2.HttpException(message, status);
        }
    }
    async getPixQrCode(paymentId) {
        const { data } = await (0, rxjs_1.firstValueFrom)(this.http.get(`${this.baseURL}/payments/${paymentId}/pixQrCode`, { headers: this.headers }));
        return data;
    }
    async fakePayment(userId, orderId) {
        const order = await this.orderRepositoty.findOne({
            where: {
                id: orderId,
            },
            relations: ['user']
        });
        if (!order) {
            throw new common_2.NotFoundException("Ops. Nenhum pedido pendente de pagamento localizado para esse usuário");
        }
        order.status = enum_1.Status.PAID;
        await this.orderRepositoty.save(order);
        this.eventEmitter.emit('payment.confirmed', {
            orderId: order.id,
        });
        return { message: "Pagamento feito" };
    }
    async createSubscription(userId) {
        try {
            const user = await this.userRepository.findOne({
                where: { id: userId }
            });
            if (!user) {
                throw new common_2.NotFoundException('Usuário não encontrado para criar assinatura');
            }
            const customerId = await this.getOrCreateCustomer(user);
            const assinaturaCriada = await this.http.post(`${this.baseURL}/subscriptions`, {
                customer: customerId,
                billingType: "PIX",
                nextDueDate: "2025-10-27",
                value: 10.0,
                cycle: `WEEKLY`,
                description: `Assinatura teste SEMANAL`,
            }, {
                headers: this.headers
            });
            const response = await (0, rxjs_1.lastValueFrom)(assinaturaCriada);
            const data = response.data;
            const asaasSubscriptionId = data.id;
            console.log("RESPONSE ASASS ", response);
            return data;
        }
        catch (error) {
            throw new common_2.HttpException(`Erro ao criar assinatura no Asaas: `, error);
        }
    }
    async paySubscription(userId) {
        try {
            const creditCard = await this.creditcardRepository.findOne({ where: { user: userId } });
            if (!creditCard) {
                throw new common_2.NotFoundException('Cartão de crédito não encontrado para pagamento da assinatura');
            }
            const user = await this.userRepository.findOne({ where: { id: userId } });
            console.log("USER ", user);
            if (!user) {
                throw new common_2.NotFoundException('Usuário não encontrado para pagamento da assinatura');
            }
            const customerId = await this.getOrCreateCustomer(user);
            const decryptedCreditCard = {
                credit_card_holder_name: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_holder_name),
                credit_card_number: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_number),
                credit_card_expiry_month: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_month),
                credit_card_expiry_year: encrypt_1.CryptoUtil.decrypt(creditCard.credit_card_expiry_year),
                ccv: encrypt_1.CryptoUtil.decrypt(creditCard.ccv),
            };
            const pagamentoCriado = await this.http.post(`${this.baseURL}/payments`, {
                customer: customerId,
                billingType: "CREDIT_CARD",
                value: 10.0,
                dueDate: "2025-11-08",
                description: "Pagamento da assinatura semanal",
                creditCard: {
                    holderName: decryptedCreditCard.credit_card_holder_name,
                    number: decryptedCreditCard.credit_card_number,
                    expiryMonth: decryptedCreditCard.credit_card_expiry_month,
                    expiryYear: decryptedCreditCard.credit_card_expiry_year,
                    ccv: decryptedCreditCard.ccv,
                },
                creditCardHolderInfo: {
                    name: user.user_name,
                    email: user.email,
                    cpfCnpj: user.document,
                    postalCode: user.cep,
                    addressNumber: user.house_number,
                    phone: user.cellphone,
                },
            }, { headers: this.headers });
            const response = await (0, rxjs_1.lastValueFrom)(pagamentoCriado);
            const data = response.data;
            console.log("PAGAMENTO REALIZADO: ", data);
            return data;
        }
        catch (error) {
            console.error("Erro ao pagar assinatura: ", error.response?.data || error.message);
            throw new common_2.HttpException('Erro ao processar pagamento no Asaas', common_2.HttpStatus.BAD_REQUEST);
        }
    }
    async getUserSubscriptions(userId) {
        try {
            const user = await this.userRepository.findOne({ where: { id: userId } });
            if (!user) {
                throw new common_2.NotFoundException('Usuário não encontrado');
            }
            const customerId = await this.getOrCreateCustomer(user);
            const response = await this.http.get(`${this.baseURL}/subscriptions?customer=${customerId}`, { headers: this.headers });
            const result = await (0, rxjs_1.lastValueFrom)(response);
            const subscriptions = result.data?.data || [];
            console.log("ASSINATURAS DO USUÁRIO:", subscriptions);
            return subscriptions;
        }
        catch (error) {
            console.error('Erro ao buscar assinaturas no Asaas:', error.response?.data || error.message);
            throw new common_2.HttpException('Erro ao buscar assinaturas do usuário no Asaas', common_2.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.AsaasService = AsaasService;
exports.AsaasService = AsaasService = __decorate([
    (0, common_2.Injectable)(),
    __param(2, (0, common_2.Inject)((0, common_2.forwardRef)(() => orders_service_1.OrdersService))),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(4, (0, typeorm_1.InjectRepository)(creditcard_entity_1.Creditcard)),
    __param(5, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(6, (0, typeorm_1.InjectRepository)(course_payment_entity_1.Course_payment)),
    __metadata("design:paramtypes", [axios_1.HttpService,
        event_emitter_1.EventEmitter2,
        orders_service_1.OrdersService,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], AsaasService);
//# sourceMappingURL=asaas.service.js.map